/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.LoggerImpl;
import com.metaring.framework.util.log.LogMessageType;
import com.metaring.framework.util.log.LogMessageTypeProvider;
import com.metaring.framework.util.log.Logger;
import com.metaring.framework.util.log.LoggerFactory;

final class LoggerFactoryImpl
implements LoggerFactory {
    private LogMessageTypeProvider logMessageTypeProvider;
    private Long defaultStackPosition;

    public LoggerFactoryImpl(LogMessageTypeProvider logMessageTypeProvider) {
        this.logMessageTypeProvider = logMessageTypeProvider;
        this.defaultStackPosition = 3L;
    }

    public Logger create(String loggedSystemName) {
        Logger logger = this.create(loggedSystemName, null, this.defaultStackPosition);
        return logger;
    }

    public Logger create(String loggedSystemName, LogMessageType minimumLogMessageType) {
        Logger logger = this.create(loggedSystemName, minimumLogMessageType, this.defaultStackPosition);
        return logger;
    }

    public Logger create(String loggedSystemName, Long stackPosition) {
        Logger logger = this.create(loggedSystemName, null, stackPosition);
        return logger;
    }

    public Logger create(String loggedSystemName, LogMessageType minimumLogMessageType, Long stackPosition) {
        if (loggedSystemName == null) {
            return null;
        }
        if (minimumLogMessageType == null) {
            minimumLogMessageType = this.logMessageTypeProvider.INFO();
        }
        LoggerImpl logger = new LoggerImpl(loggedSystemName, minimumLogMessageType, stackPosition);
        return logger;
    }
}

