/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.DigitSeriesImpl;
import com.metaring.framework.type.factory.DigitSeriesFactory;
import com.metaring.framework.type.series.DigitSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

final class DigitSeriesFactoryImpl
implements DigitSeriesFactory {
    private final Function<String, Stream<String>> fromJsonToStringsFunction;

    DigitSeriesFactoryImpl(Function<String, Stream<String>> fromJsonToStringsFunction) {
        this.fromJsonToStringsFunction = fromJsonToStringsFunction;
    }

    public DigitSeries create(Iterable<Long> iterable) {
        return new DigitSeriesImpl(iterable);
    }

    public DigitSeries create(Long ... digits) {
        return this.create(digits == null ? new ArrayList() : Arrays.asList(digits));
    }

    public DigitSeries fromJson(String json) {
        Stream<String> strings = this.fromJsonToStringsFunction.apply(json);
        return strings == null ? null : this.create((Long[])strings.map(Long::new).toArray(Long[]::new));
    }
}

