/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.rpc.auth;

import com.metaring.framework.SysKB;
import com.metaring.framework.auth.InternalFunctionalityAccessException;
import com.metaring.framework.functionality.FunctionalitiesInfoProvider;
import com.metaring.framework.functionality.FunctionalitiesManager;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityExecutionResult;
import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.rpc.RestrictedFunctionalityAccessException;
import com.metaring.framework.rpc.RpcRequest;
import com.metaring.framework.rpc.RpcResponse;
import com.metaring.framework.rpc.auth.AuthFunctionalitiesManager;
import com.metaring.framework.rpc.auth.CallReservedFunctionality;
import com.metaring.framework.rpc.auth.IdentificationDataAlreadyExistsException;
import com.metaring.framework.rpc.auth.IdentificationVerificationFailedException;
import com.metaring.framework.rpc.auth.MissingRpcValueException;
import com.metaring.framework.rpc.auth.RpcAuthHelper;
import com.metaring.framework.type.DataRepresentation;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class CallReservedFunctionalityImpl
extends CallReservedFunctionality {
    private static final String CALL_RESTRICTED_FUNCTIONALITY_FULLY_QUALIFIED_NAME = AuthFunctionalitiesManager.CALL_RESTRICTED.getFunctionalityFullyQualifiedName();

    protected CallReservedFunctionalityImpl(SysKB sysKB) {
        super(sysKB);
    }

    @Override
    protected CompletableFuture<Void> afterPreConditionCheck(RpcRequest input) throws Exception {
        RpcAuthHelper.putIdentificationData(this.getContext(), input.getData());
        return end;
    }

    @Override
    protected CompletableFuture<Void> postConditionCheck(RpcRequest input, RpcResponse rpcResponse) throws Exception {
        return end;
    }

    @Override
    protected CompletableFuture<Void> preConditionCheck(RpcRequest input) throws Exception {
        if (RpcAuthHelper.getIdentificationData(this.getContext()) != null) {
            throw new IdentificationDataAlreadyExistsException(this.getContext());
        }
        if (input == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest");
        }
        if (input.getData() == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.data");
        }
        if (input.getName() == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.name");
        }
        String functionalityName = input.getName();
        FunctionalityInfo functionalityInfo = FunctionalitiesInfoProvider.get((String)functionalityName);
        if (functionalityInfo == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "functionalityInfo");
        }
        if (functionalityInfo.isRestricted().booleanValue() && !functionalityName.equalsIgnoreCase(CALL_RESTRICTED_FUNCTIONALITY_FULLY_QUALIFIED_NAME)) {
            throw new RestrictedFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        if (functionalityInfo.isInternal().booleanValue() && !functionalityName.equalsIgnoreCase(CALL_RESTRICTED_FUNCTIONALITY_FULLY_QUALIFIED_NAME)) {
            throw new InternalFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        CompletableFuture completableFuture = com.metaring.framework.auth.AuthFunctionalitiesManager.verifyIdentification((DataRepresentation)input.getData());
        if (!completableFuture.isDone()) {
            CompletableFuture completableFuture2 = completableFuture;
            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallReservedFunctionalityImpl.async$preConditionCheck(this, input, functionalityName, functionalityInfo, completableFuture2, 1, arg_0));
        }
        Boolean result = (Boolean)completableFuture.join();
        if (result == null || !result.booleanValue()) {
            throw new IdentificationVerificationFailedException();
        }
        return end;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ CompletableFuture async$preConditionCheck(CallReservedFunctionalityImpl var0, RpcRequest var1_1, String var2_2, FunctionalityInfo var3_3, CompletableFuture var4_4, int var5_5, Object var6_7) throws Exception {
        switch (var5_5) {
            case 0: {
                if (RpcAuthHelper.getIdentificationData(this.getContext()) != null) {
                    throw new IdentificationDataAlreadyExistsException(this.getContext());
                }
                if (input == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest");
                }
                if (input.getData() == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.data");
                }
                if (input.getName() == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.name");
                }
                functionalityName = input.getName();
                functionalityInfo = FunctionalitiesInfoProvider.get((String)functionalityName);
                if (functionalityInfo == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "functionalityInfo");
                }
                if (functionalityInfo.isRestricted().booleanValue() && !functionalityName.equalsIgnoreCase(CallReservedFunctionalityImpl.CALL_RESTRICTED_FUNCTIONALITY_FULLY_QUALIFIED_NAME)) {
                    throw new RestrictedFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
                }
                if (functionalityInfo.isInternal().booleanValue() && !functionalityName.equalsIgnoreCase(CallReservedFunctionalityImpl.CALL_RESTRICTED_FUNCTIONALITY_FULLY_QUALIFIED_NAME)) {
                    throw new InternalFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
                }
                v0 = com.metaring.framework.auth.AuthFunctionalitiesManager.verifyIdentification((DataRepresentation)input.getData());
                if (!v0.isDone()) {
                    var5_6 = v0;
                    return var5_6.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$preConditionCheck(com.metaring.framework.rpc.auth.CallReservedFunctionalityImpl com.metaring.framework.rpc.RpcRequest java.lang.String com.metaring.framework.functionality.FunctionalityInfo java.util.concurrent.CompletableFuture int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((CallReservedFunctionalityImpl)this, (RpcRequest)input, (String)functionalityName, (FunctionalityInfo)functionalityInfo, (CompletableFuture)var5_6, (int)1));
                }
lbl23:
                // 3 sources

                while (true) {
                    result = (Boolean)v0.join();
                    if (result == null || !result.booleanValue()) {
                        throw new IdentificationVerificationFailedException();
                    }
                    return CallReservedFunctionalityImpl.end;
                }
            }
            case 1: {
                v0 = var4_4;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CompletableFuture<RpcResponse> call(RpcRequest input) throws Exception {
        CallReservedFunctionalityImpl callReservedFunctionalityImpl = this;
        Long l = input.getId();
        CompletableFuture completableFuture = FunctionalitiesManager.executeFromJson((String)input.getName(), (Functionality)this, (String)(input.getParam() == null ? "null" : input.getParam().toJson()));
        if (!completableFuture.isDone()) {
            CompletableFuture completableFuture2 = completableFuture;
            Long l2 = l;
            CallReservedFunctionalityImpl callReservedFunctionalityImpl2 = callReservedFunctionalityImpl;
            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallReservedFunctionalityImpl.async$call(this, input, callReservedFunctionalityImpl2, l2, completableFuture2, 1, arg_0));
        }
        return callReservedFunctionalityImpl.end(RpcResponse.create(l, (FunctionalityExecutionResult)completableFuture.join(), null));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ CompletableFuture async$call(CallReservedFunctionalityImpl callReservedFunctionalityImpl, RpcRequest rpcRequest, CallReservedFunctionalityImpl callReservedFunctionalityImpl2, Long l, CompletableFuture completableFuture, int n, Object object) throws Exception {
        switch (n) {
            case 0: {
                void input;
                CallReservedFunctionalityImpl callReservedFunctionalityImpl3 = this;
                Long l2 = input.getId();
                CompletableFuture completableFuture2 = FunctionalitiesManager.executeFromJson((String)input.getName(), (Functionality)this, (String)(input.getParam() == null ? "null" : input.getParam().toJson()));
                if (!completableFuture2.isDone()) {
                    completableFuture = completableFuture2;
                    l = l2;
                    callReservedFunctionalityImpl2 = callReservedFunctionalityImpl3;
                    return ((CompletableFuture)completableFuture.exceptionally(Function.identity())).thenCompose(arg_0 -> CallReservedFunctionalityImpl.async$call(this, (RpcRequest)input, callReservedFunctionalityImpl2, l, completableFuture, 1, arg_0));
                }
                return callReservedFunctionalityImpl3.end(RpcResponse.create(l2, (FunctionalityExecutionResult)completableFuture2.join(), null));
            }
            case 1: {
                CallReservedFunctionalityImpl callReservedFunctionalityImpl3 = callReservedFunctionalityImpl2;
                Long l2 = l;
                CompletableFuture completableFuture2 = completableFuture;
                return callReservedFunctionalityImpl3.end(RpcResponse.create(l2, (FunctionalityExecutionResult)completableFuture2.join(), null));
            }
        }
        throw new IllegalArgumentException();
    }
}

