/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.rpc;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;

public class RpcRequest
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.rpc.rpcRequest";
    private Long id;
    private DataRepresentation data;
    private String name;
    private DataRepresentation param;

    private RpcRequest(Long id, DataRepresentation data, String name, DataRepresentation param) {
        this.id = id;
        this.data = data;
        this.name = name;
        this.param = param;
    }

    public Long getId() {
        return this.id;
    }

    public DataRepresentation getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public DataRepresentation getParam() {
        return this.param;
    }

    public static RpcRequest create(Long id, DataRepresentation data, String name, DataRepresentation param) {
        return new RpcRequest(id, data, name, param);
    }

    public static RpcRequest fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        Long id = null;
        if (dataRepresentation.hasProperty("id").booleanValue()) {
            try {
                id = dataRepresentation.getDigit("id");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataRepresentation data = null;
        if (dataRepresentation.hasProperty("data").booleanValue()) {
            try {
                data = dataRepresentation.get("data");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String name = null;
        if (dataRepresentation.hasProperty("name").booleanValue()) {
            try {
                name = dataRepresentation.getText("name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DataRepresentation param = null;
        if (dataRepresentation.hasProperty("param").booleanValue()) {
            try {
                param = dataRepresentation.get("param");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RpcRequest rpcRequest = RpcRequest.create(id, data, name, param);
        return rpcRequest;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.id != null) {
            dataRepresentation.add("id", this.id);
        }
        if (this.data != null) {
            dataRepresentation.add("data", this.data);
        }
        if (this.name != null) {
            dataRepresentation.add("name", this.name);
        }
        if (this.param != null) {
            dataRepresentation.add("param", this.param);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

