/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.rpc.auth;

import com.metaring.framework.SysKB;
import com.metaring.framework.auth.AuthFunctionalitiesManager;
import com.metaring.framework.auth.InternalFunctionalityAccessException;
import com.metaring.framework.auth.PreliminaryEnableData;
import com.metaring.framework.functionality.CriticalMissingValuesException;
import com.metaring.framework.functionality.FunctionalitiesInfoProvider;
import com.metaring.framework.functionality.FunctionalitiesManager;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityExecutionResult;
import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.rpc.RpcRequest;
import com.metaring.framework.rpc.RpcResponse;
import com.metaring.framework.rpc.auth.CallRestrictedFunctionality;
import com.metaring.framework.rpc.auth.EnableDataAlreadyExistsException;
import com.metaring.framework.rpc.auth.EnableVerificationFailedException;
import com.metaring.framework.rpc.auth.MissingRpcValueException;
import com.metaring.framework.rpc.auth.NoValidIdentificationDataProvidedException;
import com.metaring.framework.rpc.auth.RpcAuthHelper;
import com.metaring.framework.type.DataRepresentation;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class CallRestrictedFunctionalityImpl
extends CallRestrictedFunctionality {
    protected CallRestrictedFunctionalityImpl(SysKB sysKB) {
        super(sysKB);
    }

    @Override
    protected CompletableFuture<Void> afterPreConditionCheck(RpcRequest input) throws Exception {
        RpcAuthHelper.putEnableData(this.getContext(), input.getData());
        return end;
    }

    @Override
    protected final CompletableFuture<Void> postConditionCheck(RpcRequest input, RpcResponse rpcResponse) throws Exception {
        return end;
    }

    @Override
    protected final CompletableFuture<Void> preConditionCheck(RpcRequest input) throws Exception {
        if (RpcAuthHelper.getIdentificationData(this.getContext()) == null) {
            throw new NoValidIdentificationDataProvidedException(this.getContext().getStackElementSeries());
        }
        if (RpcAuthHelper.getEnableData(this.getContext()) != null) {
            throw new EnableDataAlreadyExistsException(this.getContext());
        }
        if (input == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData");
        }
        DataRepresentation enableData = input.getData();
        if (enableData == null || enableData.isNull().booleanValue()) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData.enableData");
        }
        String functionalityName = input.getName();
        if (functionalityName == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData.name");
        }
        FunctionalityInfo functionalityInfo = FunctionalitiesInfoProvider.get((String)functionalityName);
        if (functionalityInfo == null) {
            throw new CriticalMissingValuesException(this.getContext().getStackElementSeries(), new String[]{"functionalityInfo"});
        }
        if (functionalityInfo.isInternal().booleanValue()) {
            throw new InternalFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        CompletableFuture completableFuture = AuthFunctionalitiesManager.verifyEnable((PreliminaryEnableData)((PreliminaryEnableData)input.toDataRepresentation().add("functionalityName", functionalityName).add("functionalityParam", input.getParam()).as(PreliminaryEnableData.class)));
        if (!completableFuture.isDone()) {
            CompletableFuture completableFuture2 = completableFuture;
            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallRestrictedFunctionalityImpl.async$preConditionCheck(this, input, enableData, functionalityName, functionalityInfo, completableFuture2, 1, arg_0));
        }
        Boolean result = (Boolean)completableFuture.join();
        if (result == null || !result.booleanValue()) {
            throw new EnableVerificationFailedException();
        }
        return end;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ CompletableFuture async$preConditionCheck(CallRestrictedFunctionalityImpl var0, RpcRequest var1_1, DataRepresentation var2_2, String var3_3, FunctionalityInfo var4_4, CompletableFuture var5_5, int var6_6, Object var7_8) throws Exception {
        switch (var6_6) {
            case 0: {
                if (RpcAuthHelper.getIdentificationData(this.getContext()) == null) {
                    throw new NoValidIdentificationDataProvidedException(this.getContext().getStackElementSeries());
                }
                if (RpcAuthHelper.getEnableData(this.getContext()) != null) {
                    throw new EnableDataAlreadyExistsException(this.getContext());
                }
                if (input == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData");
                }
                enableData = input.getData();
                if (enableData == null || enableData.isNull().booleanValue()) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData.enableData");
                }
                functionalityName = input.getName();
                if (functionalityName == null) {
                    throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.enableData.name");
                }
                functionalityInfo = FunctionalitiesInfoProvider.get((String)functionalityName);
                if (functionalityInfo == null) {
                    throw new CriticalMissingValuesException(this.getContext().getStackElementSeries(), new String[]{"functionalityInfo"});
                }
                if (functionalityInfo.isInternal().booleanValue()) {
                    throw new InternalFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
                }
                v0 = AuthFunctionalitiesManager.verifyEnable((PreliminaryEnableData)((PreliminaryEnableData)input.toDataRepresentation().add("functionalityName", functionalityName).add("functionalityParam", input.getParam()).as(PreliminaryEnableData.class)));
                if (!v0.isDone()) {
                    var6_7 = v0;
                    return var6_7.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$preConditionCheck(com.metaring.framework.rpc.auth.CallRestrictedFunctionalityImpl com.metaring.framework.rpc.RpcRequest com.metaring.framework.type.DataRepresentation java.lang.String com.metaring.framework.functionality.FunctionalityInfo java.util.concurrent.CompletableFuture int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((CallRestrictedFunctionalityImpl)this, (RpcRequest)input, (DataRepresentation)enableData, (String)functionalityName, (FunctionalityInfo)functionalityInfo, (CompletableFuture)var6_7, (int)1));
                }
lbl24:
                // 3 sources

                while (true) {
                    result = (Boolean)v0.join();
                    if (result == null || !result.booleanValue()) {
                        throw new EnableVerificationFailedException();
                    }
                    return CallRestrictedFunctionalityImpl.end;
                }
            }
            case 1: {
                v0 = var5_5;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected final CompletableFuture<RpcResponse> call(RpcRequest input) throws Exception {
        Long l = input.getId();
        CompletableFuture completableFuture = FunctionalitiesManager.executeFromJson((String)input.getName(), (Functionality)this, (String)(input.getParam() == null ? "null" : input.getParam().toJson()));
        if (!completableFuture.isDone()) {
            CompletableFuture completableFuture2 = completableFuture;
            Long l2 = l;
            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallRestrictedFunctionalityImpl.async$call(this, input, l2, completableFuture2, 1, arg_0));
        }
        return CompletableFuture.completedFuture(RpcResponse.create(l, (FunctionalityExecutionResult)completableFuture.join(), null));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ CompletableFuture async$call(CallRestrictedFunctionalityImpl callRestrictedFunctionalityImpl, RpcRequest rpcRequest, Long l, CompletableFuture completableFuture, int n, Object object) throws Exception {
        switch (n) {
            case 0: {
                void input;
                Long l2 = input.getId();
                CompletableFuture completableFuture2 = FunctionalitiesManager.executeFromJson((String)input.getName(), (Functionality)this, (String)(input.getParam() == null ? "null" : input.getParam().toJson()));
                if (!completableFuture2.isDone()) {
                    completableFuture = completableFuture2;
                    l = l2;
                    return ((CompletableFuture)completableFuture.exceptionally(Function.identity())).thenCompose(arg_0 -> CallRestrictedFunctionalityImpl.async$call(this, (RpcRequest)input, l, completableFuture, 1, arg_0));
                }
                return CompletableFuture.completedFuture(RpcResponse.create(l2, (FunctionalityExecutionResult)completableFuture2.join(), null));
            }
            case 1: {
                Long l2 = l;
                CompletableFuture completableFuture2 = completableFuture;
                return CompletableFuture.completedFuture(RpcResponse.create(l2, (FunctionalityExecutionResult)completableFuture2.join(), null));
            }
        }
        throw new IllegalArgumentException();
    }
}

