/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.rpc;

import com.metaring.framework.Core;
import com.metaring.framework.Tools;
import com.metaring.framework.auth.InternalFunctionalityAccessException;
import com.metaring.framework.crypto.CryptoFunctionalitiesManager;
import com.metaring.framework.email.BugReportMail;
import com.metaring.framework.exception.ManagedException;
import com.metaring.framework.functionality.FunctionalitiesInfoProvider;
import com.metaring.framework.functionality.FunctionalitiesManager;
import com.metaring.framework.functionality.FunctionalitiesProvider;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityContext;
import com.metaring.framework.functionality.FunctionalityCreationException;
import com.metaring.framework.functionality.FunctionalityExecutionError;
import com.metaring.framework.functionality.FunctionalityExecutionResult;
import com.metaring.framework.functionality.FunctionalityExecutionVerdictEnumerator;
import com.metaring.framework.functionality.FunctionalityExecutionWarningData;
import com.metaring.framework.functionality.FunctionalityExecutionWarningDataSeries;
import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.rpc.CallFunctionality;
import com.metaring.framework.rpc.ReserverdFunctionalityAccessException;
import com.metaring.framework.rpc.RestrictedFunctionalityAccessException;
import com.metaring.framework.rpc.RpcFunctionalitiesManager;
import com.metaring.framework.rpc.RpcRequest;
import com.metaring.framework.rpc.RpcResponse;
import com.metaring.framework.rpc.auth.AuthFunctionalitiesManager;
import com.metaring.framework.rpc.auth.MissingRpcValueException;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.ObjectUtil;
import com.metaring.framework.util.StringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class CallFunctionalityImpl
extends CallFunctionality {
    private static final String CALL_RESERVED_FUNCTIONALITY_NAME = AuthFunctionalitiesManager.CALL_RESERVED.getFunctionalityFullyQualifiedName();
    public static final String KEY_ID = "functionality.id";
    public static final String KEY_SOURCE_IP = "functionality.ip";
    public static final String KEY_DATA = "functionality.data";

    public static final CompletableFuture<FunctionalityExecutionResult> execute(Long id, String sourceIp, String broadcastKeyName, String broadcastKey, boolean stateless, String rpcRequest) {
        FunctionalityContext functionalityContext = new FunctionalityContext();
        functionalityContext.getData().put(KEY_ID, (Object)id);
        functionalityContext.getData().put(KEY_SOURCE_IP, (Object)sourceIp);
        functionalityContext.getData().put(KEY_DATA, (Object)Tools.FACTORY_DATA_REPRESENTATION.create());
        functionalityContext.getData().put("verify.identification.stateless", (Object)stateless);
        if (!StringUtil.isNullOrEmpty((String)broadcastKey)) {
            functionalityContext.getData().put(broadcastKeyName, (Object)broadcastKey);
        }
        try {
            return ((CallFunctionalityImpl)FunctionalitiesProvider.getFunctionality((FunctionalityInfo)RpcFunctionalitiesManager.CALL, CallFunctionality.class)).execute(functionalityContext, RpcRequest.fromJson(rpcRequest));
        }
        catch (FunctionalityCreationException e) {
            return null;
        }
    }

    public final CompletableFuture<FunctionalityExecutionResult> execute(FunctionalityContext context, RpcRequest reuest) {
        return super.execute(context, (Object)reuest);
    }

    @Override
    protected final CompletableFuture<Void> preConditionCheck(RpcRequest rpcRequest) throws Exception {
        if (rpcRequest == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest");
        }
        if (rpcRequest.getId() == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.id");
        }
        if (rpcRequest.getName() == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "rpcRequest.name");
        }
        String functionalityName = rpcRequest.getName();
        FunctionalityInfo functionalityInfo = FunctionalitiesInfoProvider.get((String)functionalityName);
        if (functionalityInfo == null) {
            throw new MissingRpcValueException(this.getContext().getStackElementSeries(), "functionalityInfo");
        }
        if (functionalityInfo.isInternal().booleanValue() && !functionalityName.equals(CALL_RESERVED_FUNCTIONALITY_NAME)) {
            throw new InternalFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        if (functionalityInfo.isReserved().booleanValue()) {
            throw new ReserverdFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        if (functionalityInfo.isRestricted().booleanValue()) {
            throw new RestrictedFunctionalityAccessException(this.getContext().getStackElementSeries(), functionalityName);
        }
        return end;
    }

    @Override
    protected final CompletableFuture<RpcResponse> call(RpcRequest rpcRequest) throws Exception {
        Executor executor = EXECUTOR;
        CompletableFuture<RpcResponse> call = new CompletableFuture<RpcResponse>();
        String jsonParam = rpcRequest.getParam() == null ? "null" : rpcRequest.getParam().toJson();
        FunctionalitiesManager.executeFromJson((String)rpcRequest.getName(), (Functionality)this, (String)jsonParam).whenCompleteAsync((result, error) -> {
            if (error != null) {
                call.completeExceptionally((Throwable)error);
                return;
            }
            this.mergeResultAndExit(rpcRequest, (FunctionalityExecutionResult)result).whenCompleteAsync((r, e) -> {
                if (e != null) {
                    call.completeExceptionally((Throwable)e);
                    return;
                }
                call.complete((RpcResponse)r);
            }, executor);
        }, executor);
        return call;
    }

    @Override
    protected CompletableFuture<Void> postConditionCheck(RpcRequest input, RpcResponse output) throws Exception {
        return end;
    }

    private final void fillWarningDatas(FunctionalityExecutionResult result, LinkedList<FunctionalityExecutionWarningData> warningsList) {
        if (result != null && result.getWarningData() != null) {
            FunctionalityExecutionWarningDataSeries series = result.getWarningData();
            int size = series.size();
            for (int i = 0; i < size; ++i) {
                warningsList.addLast((FunctionalityExecutionWarningData)series.get(i));
            }
        }
    }

    private final String cleanStackTrace(Exception e) {
        String stackTrace = StringUtil.fromThrowableToString((Throwable)e);
        return stackTrace.substring(stackTrace.indexOf("STACK:\n\n\t"), stackTrace.indexOf("\n\n]EXCEPTION END["));
    }

    public CallFunctionality setParameter(String key, Object value) {
        this.setContextData(key, value);
        return this;
    }

    private CompletableFuture<RpcResponse> mergeResultAndExit(RpcRequest input, FunctionalityExecutionResult functionalityExecutionResult) {
        CompletableFuture<DataRepresentation> completableFuture = this.tryPrintError(input, functionalityExecutionResult);
        if (!completableFuture.isDone()) {
            CompletableFuture<DataRepresentation> completableFuture2 = completableFuture;
            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallFunctionalityImpl.async$mergeResultAndExit(this, input, functionalityExecutionResult, completableFuture2, 1, arg_0));
        }
        DataRepresentation returnData = completableFuture.join();
        FunctionalityExecutionResult result = functionalityExecutionResult;
        FunctionalityExecutionVerdictEnumerator verdict = FunctionalityExecutionVerdictEnumerator.SUCCESS;
        LinkedList<FunctionalityExecutionWarningData> warningsList = new LinkedList<FunctionalityExecutionWarningData>();
        if (result != null) {
            while (result.getVerdict() != FunctionalityExecutionVerdictEnumerator.FAULT) {
                verdict = result.getVerdict();
                this.fillWarningDatas(result, warningsList);
                DataRepresentation r = result.getResult();
                if (r == null || r.isNull().booleanValue()) break;
                if (result.getResultIdentificator().equals(FunctionalityExecutionResult.class.getName())) {
                    result = (FunctionalityExecutionResult)r.as(FunctionalityExecutionResult.class);
                    continue;
                }
                if (!result.getResultIdentificator().equals(RpcResponse.class.getName())) break;
                result = ((RpcResponse)r.as(RpcResponse.class)).getResult();
            }
            if (result.getVerdict() == FunctionalityExecutionVerdictEnumerator.FAULT) {
                verdict = result.getVerdict();
                this.fillWarningDatas(result, warningsList);
            }
            result = FunctionalityExecutionResult.create((FunctionalityExecutionVerdictEnumerator)verdict, warningsList == null || warningsList.isEmpty() ? null : FunctionalityExecutionWarningDataSeries.create((FunctionalityExecutionWarningData[])warningsList.toArray(new FunctionalityExecutionWarningData[warningsList.size()])), (FunctionalityExecutionError)result.getErrorData(), (String)result.getResultIdentificator(), (DataRepresentation)result.getResult());
        }
        return CompletableFuture.completedFuture(RpcResponse.create(input.getId(), result, returnData));
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ CompletableFuture async$mergeResultAndExit(CallFunctionalityImpl var0, RpcRequest var1_1, FunctionalityExecutionResult var2_2, CompletableFuture var3_3, int var4_4, Object var5_6) {
        switch (var4_4) {
            case 0: {
                v0 = this.tryPrintError((RpcRequest)input, (FunctionalityExecutionResult)functionalityExecutionResult);
                if (!v0.isDone()) {
                    var8_7 = v0;
                    return var8_7.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$mergeResultAndExit(com.metaring.framework.rpc.CallFunctionalityImpl com.metaring.framework.rpc.RpcRequest com.metaring.framework.functionality.FunctionalityExecutionResult java.util.concurrent.CompletableFuture int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((CallFunctionalityImpl)this, (RpcRequest)input, (FunctionalityExecutionResult)functionalityExecutionResult, var8_7, (int)1));
                }
lbl7:
                // 3 sources

                while (true) {
                    returnData = (DataRepresentation)v0.join();
                    result = functionalityExecutionResult;
                    verdict = FunctionalityExecutionVerdictEnumerator.SUCCESS;
                    warningsList = new LinkedList<FunctionalityExecutionWarningData>();
                    if (result != null) {
                        while (result.getVerdict() != FunctionalityExecutionVerdictEnumerator.FAULT) {
                            verdict = result.getVerdict();
                            this.fillWarningDatas(result, warningsList);
                            r = result.getResult();
                            if (r == null || r.isNull().booleanValue()) break;
                            if (result.getResultIdentificator().equals(FunctionalityExecutionResult.class.getName())) {
                                result = (FunctionalityExecutionResult)r.as(FunctionalityExecutionResult.class);
                                continue;
                            }
                            if (!result.getResultIdentificator().equals(RpcResponse.class.getName())) break;
                            result = ((RpcResponse)r.as(RpcResponse.class)).getResult();
                        }
                        if (result.getVerdict() == FunctionalityExecutionVerdictEnumerator.FAULT) {
                            verdict = result.getVerdict();
                            this.fillWarningDatas(result, warningsList);
                        }
                        result = FunctionalityExecutionResult.create((FunctionalityExecutionVerdictEnumerator)verdict, warningsList == null || warningsList.isEmpty() != false ? null : FunctionalityExecutionWarningDataSeries.create((FunctionalityExecutionWarningData[])warningsList.toArray(new FunctionalityExecutionWarningData[warningsList.size()])), (FunctionalityExecutionError)result.getErrorData(), (String)result.getResultIdentificator(), (DataRepresentation)result.getResult());
                    }
                    return CompletableFuture.completedFuture(RpcResponse.create(input.getId(), result, returnData));
                }
            }
            case 1: {
                v0 = var3_3;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }

    private final CompletableFuture<DataRepresentation> tryPrintError(RpcRequest input, FunctionalityExecutionResult functionalityExecutionResult) {
        DataRepresentation responseData;
        block7: {
            responseData = (DataRepresentation)this.getContextData(KEY_DATA);
            try {
                FunctionalitiesManager.verifyAndReturnFunctionalityExecutionResult((FunctionalityExecutionResult)functionalityExecutionResult);
            }
            catch (Exception e) {
                if (e instanceof ManagedException) break block7;
                responseData = null;
                String stackTrace = this.cleanStackTrace(e);
                System.err.println("UNMANAGED EXCEPTION:\n\n" + stackTrace + "\n");
                try {
                    if (!ObjectUtil.isNullOrEmpty((DataRepresentation)Core.SYSKB.get("email")) && !ObjectUtil.isNullOrEmpty((DataRepresentation)Core.SYSKB.get("email").get("supportTeam"))) {
                        Long l = (Long)this.getContextData(KEY_ID);
                        CompletableFuture completableFuture = CryptoFunctionalitiesManager.encrypt(null, (String)((String)this.getContextData(KEY_SOURCE_IP)));
                        if (!completableFuture.isDone()) {
                            CompletableFuture completableFuture2 = completableFuture;
                            Long l2 = l;
                            return ((CompletableFuture)completableFuture2.exceptionally(Function.identity())).thenCompose(arg_0 -> CallFunctionalityImpl.async$tryPrintError(this, input, functionalityExecutionResult, e, stackTrace, l2, completableFuture2, null, 1, arg_0));
                        }
                        String string = (String)completableFuture.join();
                        CompletableFuture completableFuture3 = CryptoFunctionalitiesManager.encrypt(null, (String)input.toJson());
                        if (!completableFuture3.isDone()) {
                            CompletableFuture completableFuture4 = completableFuture3;
                            String string2 = string;
                            Long l3 = l;
                            return ((CompletableFuture)completableFuture4.exceptionally(Function.identity())).thenCompose(arg_0 -> CallFunctionalityImpl.async$tryPrintError(this, input, functionalityExecutionResult, e, stackTrace, l3, completableFuture4, string2, 2, arg_0));
                        }
                        BugReportMail.send((Long)l, (String)string, (String)((String)completableFuture3.join()), (FunctionalityExecutionResult)functionalityExecutionResult, (String)stackTrace);
                    }
                }
                catch (Exception exx) {
                    exx.printStackTrace();
                }
            }
        }
        return this.end(responseData);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ CompletableFuture async$tryPrintError(CallFunctionalityImpl var0, RpcRequest var1_1, FunctionalityExecutionResult var2_2, Exception var3_3, String var4_4, Long var5_6, CompletableFuture var6_7, String var7_9, int var8_10, Object var9_13) {
        switch (var8_10) {
            case 0: {
                responseData = (DataRepresentation)this.getContextData("functionality.data");
                try {
                    FunctionalitiesManager.verifyAndReturnFunctionalityExecutionResult((FunctionalityExecutionResult)functionalityExecutionResult);
                }
                catch (Exception e) {
                    if (e instanceof ManagedException) ** GOTO lbl35
                    responseData = null;
                    stackTrace = this.cleanStackTrace(e);
                    System.err.println("UNMANAGED EXCEPTION:\n\n" + stackTrace + "\n");
                    try {
                        if (!ObjectUtil.isNullOrEmpty((DataRepresentation)Core.SYSKB.get("email")) && !ObjectUtil.isNullOrEmpty((DataRepresentation)Core.SYSKB.get("email").get("supportTeam"))) {
                            v0 = (Long)this.getContextData("functionality.id");
                            v1 = CryptoFunctionalitiesManager.encrypt(null, (String)((String)this.getContextData("functionality.ip")));
                            if (!v1.isDone()) {
                                var8_11 = v1;
                                var7_9 = v0;
                                return var8_11.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$tryPrintError(com.metaring.framework.rpc.CallFunctionalityImpl com.metaring.framework.rpc.RpcRequest com.metaring.framework.functionality.FunctionalityExecutionResult java.lang.Exception java.lang.String java.lang.Long java.util.concurrent.CompletableFuture java.lang.String int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((CallFunctionalityImpl)this, (RpcRequest)input, (FunctionalityExecutionResult)functionalityExecutionResult, (Exception)e, (String)stackTrace, (Long)var7_9, (CompletableFuture)var8_11, null, (int)1));
                            }
lbl21:
                            // 3 sources

                            while (true) {
                                v2 = (String)v1.join();
                                v3 = CryptoFunctionalitiesManager.encrypt(null, (String)input.toJson());
                                if (!v3.isDone()) {
                                    var9_13 = v3;
                                    var8_12 = v2;
                                    var7_9 = v0;
                                    return var9_13.exceptionally(Function.identity()).thenCompose((Function<Object, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, async$tryPrintError(com.metaring.framework.rpc.CallFunctionalityImpl com.metaring.framework.rpc.RpcRequest com.metaring.framework.functionality.FunctionalityExecutionResult java.lang.Exception java.lang.String java.lang.Long java.util.concurrent.CompletableFuture java.lang.String int java.lang.Object ), (Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;)((CallFunctionalityImpl)this, (RpcRequest)input, (FunctionalityExecutionResult)functionalityExecutionResult, (Exception)e, (String)stackTrace, (Long)var7_9, (CompletableFuture)var9_13, (String)var8_12, (int)2));
                                }
lbl29:
                                // 3 sources

                                while (true) {
                                    BugReportMail.send((Long)v0, (String)v2, (String)((String)v3.join()), (FunctionalityExecutionResult)functionalityExecutionResult, (String)stackTrace);
                                    ** GOTO lbl35
                                    break;
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception exx) {
                        exx.printStackTrace();
                    }
                }
lbl35:
                // 5 sources

                return this.end(responseData);
            }
            case 1: {
                v0 = var5_6;
                v1 = var6_7;
                var5_6 = var4_4;
                var4_4 = var3_3;
                var3_3 = null;
                ** continue;
            }
            case 2: {
                v0 = var5_6;
                v2 = var7_9;
                v3 = var6_7;
                var5_6 = var4_4;
                var4_4 = var3_3;
                var3_3 = null;
                ** continue;
            }
        }
        throw new IllegalArgumentException();
    }
}

