/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.test;

import com.metaring.framework.Core;
import com.metaring.framework.Tools;
import com.metaring.framework.persistence.PersistenceFunctionalitiesManager;
import com.metaring.framework.rpc.RpcFunctionalitiesManager;
import com.metaring.framework.rpc.RpcRequest;
import com.metaring.framework.rpc.RpcResponse;
import com.metaring.framework.test.CoreTestsBatterySupervisor;
import com.metaring.framework.test.SpecialTypeEnum;
import com.metaring.framework.test.TestBatterySupervisorManager;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.series.TextSeries;
import com.metaring.framework.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractFunctionalityTestCase {
    private static final CoreTestsBatterySupervisor SUPERVISOR;
    private static final String ERROR_MESSAGE_FORMAT = "Property: %s - Expecting %s - Found %s";
    private Long id;
    private String name;
    private String inputParam;
    private String expectedOutput;
    private String title;
    private String description;
    private TextSeries persistencePreambleActions;
    private TextSeries persistenceEpilogueVerifications;

    public AbstractFunctionalityTestCase(String title, String description, String inputParam, String expectedOutput, TextSeries persistencePreambleActions, TextSeries persistenceEpilogueVerifications) {
        this.title = title;
        this.description = description;
        this.inputParam = inputParam;
        this.expectedOutput = expectedOutput;
        this.persistencePreambleActions = persistencePreambleActions;
        this.persistenceEpilogueVerifications = persistenceEpilogueVerifications;
        long idN = 0L;
        Class<?> clazz = this.getClass();
        while (!clazz.getSuperclass().equals(AbstractFunctionalityTestCase.class)) {
            clazz = clazz.getSuperclass();
        }
        this.name = clazz.getPackage().getName();
        String simpleName = clazz.getSimpleName();
        if (Character.isDigit(simpleName.charAt(simpleName.length() - 1))) {
            int start = simpleName.length() - 1;
            while (Character.isDigit(--start)) {
            }
            idN = Long.parseLong(simpleName.substring(++start));
        }
        this.id = idN;
    }

    @Before
    public final void before() {
        if (SUPERVISOR != null) {
            try {
                SUPERVISOR.preBeforeTest();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while running Supervisor Pre Before Test", e);
            }
        }
        try {
            this.performBeforeTest();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while running Test Case Before Test", e);
        }
        if (SUPERVISOR != null) {
            try {
                SUPERVISOR.postBeforeTest();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while running Supervisor Post Before Test", e);
            }
        }
    }

    protected void performBeforeTest() throws Exception {
    }

    @Test
    public final void test() {
        CountDownLatch counter = new CountDownLatch(1);
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.performPreambleThenTest(counter, errorMessages);
        AbstractFunctionalityTestCase.await(counter);
        if (errorMessages != null && !errorMessages.isEmpty()) {
            System.err.println("\n------ ASSERTION FAILED ------");
            System.err.println("\nFunctionality: " + this.name);
            System.err.println("\nTitle: " + this.title);
            System.err.println("\nDescription: " + this.description);
            System.err.println("\nClass: " + this.getClass().getName());
            System.err.println("\nErrors:");
            for (String errorMessage : errorMessages) {
                System.err.println("\n\t- " + errorMessage + ";");
            }
            System.err.println("\n-------------------------------------");
            System.err.println("\n");
            StringBuilder message = new StringBuilder();
            for (String errorMessage : errorMessages) {
                message.append("\n\n- ").append(errorMessage).append(";");
            }
            Assert.assertTrue((String)("\n" + message.toString().trim()), (boolean)false);
        } else {
            Assert.assertTrue((boolean)true);
        }
    }

    private final void performPreambleThenTest(CountDownLatch counter, List<String> errorMessages) {
        this.performPreambleThenTest(counter, errorMessages, null);
    }

    private final void performPreambleThenTest(CountDownLatch counter, List<String> errorMessages, Integer i) {
        if (this.persistencePreambleActions == null || this.persistencePreambleActions.size() <= 0) {
            this.performTest(counter, errorMessages);
            return;
        }
        if (i != null && i.intValue() == this.persistencePreambleActions.size()) {
            try {
                this.performTest(counter, errorMessages);
            }
            catch (Exception e) {
                String errorMessageFormat = "Persistence Preamble actions commit returned the following error:\n\n%s";
                errorMessages.add(String.format(errorMessageFormat, StringUtil.fromThrowableToString((Throwable)e)));
                counter.countDown();
            }
            return;
        }
        if (i == null) {
            this.performPreambleThenTest(counter, errorMessages, 0);
            return;
        }
        String preambleAction = (String)this.persistencePreambleActions.get(i.intValue());
        try {
            PersistenceFunctionalitiesManager.update((String)preambleAction).handle((result, error) -> {
                if (error == null) {
                    this.performPreambleThenTest(counter, errorMessages, i + 1);
                } else {
                    String errorMessageFormat = "Persistence Preamble action\n\n%s\n\nreturned the following error:\n\n%s";
                    errorMessages.add(String.format(errorMessageFormat, preambleAction, StringUtil.fromThrowableToString((Throwable)error)));
                    counter.countDown();
                }
                return null;
            });
        }
        catch (Exception e) {
            String errorMessageFormat = "Persistence Preamble action\n\n%s\n\nreturned the following error:\n\n%s";
            errorMessages.add(String.format(errorMessageFormat, preambleAction, StringUtil.fromThrowableToString((Throwable)e)));
            counter.countDown();
        }
    }

    private final void performTest(CountDownLatch counter, List<String> errorMessages) {
        RpcFunctionalitiesManager.call((RpcRequest)RpcRequest.create((Long)this.id, null, (String)this.name, (DataRepresentation)Tools.FACTORY_DATA_REPRESENTATION.fromJson(this.inputParam))).handle((response, error) -> {
            this.assertResult((RpcResponse)response, result -> {
                if (result != null) {
                    errorMessages.addAll((Collection<String>)result);
                }
                counter.countDown();
            });
            return null;
        });
    }

    private final void assertResult(RpcResponse rpcResponse, Consumer<List<String>> consumer) {
        String expected = this.expectedOutput;
        DataRepresentation expectedJson = null;
        try {
            expectedJson = Tools.FACTORY_DATA_REPRESENTATION.fromJson(expected);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = rpcResponse.getResult().toJson();
        DataRepresentation resultJson = null;
        try {
            resultJson = Tools.FACTORY_DATA_REPRESENTATION.fromJson(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.verifyResult(errorMessages, "testOutput", expectedJson, resultJson);
        this.verifyEpilogueQueriesThenAccept(consumer, errorMessages);
    }

    private final void verifyEpilogueQueriesThenAccept(Consumer<List<String>> consumer, List<String> errorMessages) {
        this.verifyEpilogueQueriesThenAccept(consumer, errorMessages, null);
    }

    private final void verifyEpilogueQueriesThenAccept(Consumer<List<String>> consumer, List<String> errorMessages, Integer i) {
        if (this.persistenceEpilogueVerifications == null || this.persistenceEpilogueVerifications.size() <= 0 || i != null && i.intValue() == this.persistenceEpilogueVerifications.size()) {
            consumer.accept(errorMessages);
            return;
        }
        if (i == null) {
            this.verifyEpilogueQueriesThenAccept(consumer, errorMessages, 0);
            return;
        }
        String epilogueVerification = (String)this.persistenceEpilogueVerifications.get(i.intValue());
        String manimulatedEpilogueVerification = String.format("SELECT (CASE WHEN EXISTS (%s) THEN 'YES' ELSE 'NO' END) as result", epilogueVerification);
        try {
            PersistenceFunctionalitiesManager.query((String)manimulatedEpilogueVerification).handle((databaseResponse, error) -> {
                try {
                    if (error != null) {
                        throw error;
                    }
                    if (databaseResponse == null) {
                        throw new NullPointerException("databaseResponse");
                    }
                    if (databaseResponse.length() != 1) {
                        throw new IllegalArgumentException("Query result must return just one row");
                    }
                    if ((databaseResponse = databaseResponse.first()).getProperties().size() != 1) {
                        throw new IllegalArgumentException("Query result must return just one column");
                    }
                    String value = databaseResponse.getText((String)databaseResponse.getProperties().get(0));
                    if (!value.equals("YES")) {
                        throw new IllegalArgumentException("Expected YES, found " + value);
                    }
                }
                catch (Throwable e) {
                    String errorMessageFormat = "Persistence epilogue verification\n\n%s\n\nreturned the following error:\n\n%s";
                    errorMessages.add(String.format(errorMessageFormat, epilogueVerification, StringUtil.fromThrowableToString((Throwable)e)));
                }
                this.verifyEpilogueQueriesThenAccept(consumer, errorMessages, i + 1);
                return null;
            });
        }
        catch (Exception e) {
            String errorMessageFormat = "Persistence epilogue verification\n\n%s\n\nreturned the following error:\n\n%s";
            errorMessages.add(String.format(errorMessageFormat, epilogueVerification, StringUtil.fromThrowableToString((Throwable)e)));
            this.verifyEpilogueQueriesThenAccept(consumer, errorMessages, i + 1);
        }
    }

    private final void verifyResult(List<String> errorMessages, String propertyName, DataRepresentation expectedJson, DataRepresentation resultJson) {
        if (expectedJson == null) {
            expectedJson = Tools.FACTORY_DATA_REPRESENTATION.fromJson("null");
        }
        if (resultJson == null) {
            resultJson = Tools.FACTORY_DATA_REPRESENTATION.fromJson("null");
        }
        if (expectedJson.isNull().booleanValue() && resultJson.isNull().booleanValue()) {
            return;
        }
        if (expectedJson.isNull().booleanValue()) {
            errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, "null value", resultJson.hasLength() != false ? "an array of size " + resultJson.length() + ":\n\n" + resultJson.toString() + "\n\n" : (resultJson.hasProperties() != false ? "a JSON object:\n\n" + resultJson.toString() + "\n\n" : resultJson.toString())));
            return;
        }
        SpecialTypeEnum specialType = null;
        try {
            specialType = SpecialTypeEnum.fromText(expectedJson.toJson());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (specialType != null) {
            if (specialType == SpecialTypeEnum.ANY) {
                if (resultJson.hasLength().booleanValue()) {
                    errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, SpecialTypeEnum.ANY.getText(), "an array of size " + resultJson.length() + ":\n\n" + resultJson.toString() + "\n\n"));
                }
                return;
            }
            if (specialType == SpecialTypeEnum.SOME) {
                if (resultJson.isNull().booleanValue()) {
                    errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, SpecialTypeEnum.SOME.getText(), "null value"));
                } else if (resultJson.hasLength().booleanValue()) {
                    errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, SpecialTypeEnum.SOME.getText(), "an array of size " + resultJson.length() + ":\n\n" + resultJson.toString() + "\n\n"));
                }
                return;
            }
            if (!resultJson.hasLength().booleanValue()) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, specialType.getText(), resultJson.hasProperties() != false ? "a JSON Object:\n\n" + resultJson.toString() + "\n\n" : (resultJson.isNull() != false ? "null value" : resultJson.toString())));
                return;
            }
            if (specialType == SpecialTypeEnum.ARRAY_UNDEFINED_LENGTH) {
                return;
            }
            if (specialType == SpecialTypeEnum.ARRAY_JUST_ONE_ELEMENT && resultJson.length() != 1) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, SpecialTypeEnum.ARRAY_JUST_ONE_ELEMENT.getText(), "an array of size " + resultJson.length() + ":\n\n" + resultJson.toJson() + "\n\n"));
                return;
            }
            if (specialType == SpecialTypeEnum.ARRAY_MORE_THAN_AN_ELEMENT && resultJson.length() <= 1) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, SpecialTypeEnum.ARRAY_MORE_THAN_AN_ELEMENT.getText(), "an array of size " + resultJson.length() + ":\n\n" + resultJson.toJson() + "\n\n"));
                return;
            }
        } else if (expectedJson.hasLength().booleanValue()) {
            if (!resultJson.hasLength().booleanValue()) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, "an array of size " + expectedJson.length() + ":\n\n" + SpecialTypeEnum.clean(expectedJson.toJson()) + "\n\n", resultJson.hasProperties() != false ? "a JSON Object:\n\n" + resultJson.toString() + "\n\n" : (resultJson.isNull() != false ? "null value" : resultJson.toJson())));
                return;
            }
            if (expectedJson.length() != resultJson.length()) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, "an array of size " + expectedJson.length() + ":\n\n" + SpecialTypeEnum.clean(expectedJson.toJson()) + "\n\n", "an array of size " + resultJson.length() + ":\n\n" + resultJson.toJson() + "\n\n"));
                return;
            }
            for (int i = 0; i < expectedJson.length(); ++i) {
                this.verifyResult(errorMessages, propertyName + "[" + i + "]", expectedJson.get(i), resultJson.get(i));
            }
        } else if (expectedJson.hasProperties().booleanValue()) {
            if (!resultJson.hasProperties().booleanValue()) {
                errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, "a JSON object:\n\n" + SpecialTypeEnum.clean(expectedJson.toJson()) + "\n\n", resultJson.hasLength() != false ? "an array of size " + resultJson.length() + ":\n\n" + resultJson.toString() + "\n\n" : (resultJson.isNull() != false ? "null value" : resultJson.toString())));
                return;
            }
            TextSeries expectedPropertyNames = expectedJson.getProperties();
            for (String expectedPropertyName : expectedPropertyNames) {
                this.verifyResult(errorMessages, propertyName + "." + expectedPropertyName, expectedJson.get(expectedPropertyName), resultJson.get(expectedPropertyName));
            }
        } else if (!expectedJson.toJson().equals(resultJson.toJson())) {
            errorMessages.add(String.format(ERROR_MESSAGE_FORMAT, propertyName, expectedJson.toString(), resultJson.toString()));
        }
    }

    @After
    public final void after() {
        if (SUPERVISOR != null) {
            try {
                SUPERVISOR.preAfterTest();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while running Supervisor Pre Before Test", e);
            }
        }
        try {
            this.performAfterTest();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while running Test Case Before Test", e);
        }
        if (SUPERVISOR != null) {
            try {
                SUPERVISOR.postAfterTest();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while running Supervisor Post Before Test", e);
            }
        }
    }

    protected void performAfterTest() throws Exception {
    }

    private static final void await(CountDownLatch counter) {
        try {
            counter.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class.forName(Core.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SUPERVISOR = TestBatterySupervisorManager.initSupervisor();
    }
}

