/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.test;

enum SpecialTypeEnum {
    ANY("ANY", "*", "anything (except array)"),
    SOME("SOME", "+", "something not null (except array)"),
    ARRAY_UNDEFINED_LENGTH("ARRAY_UNDEFINED_LENGTH", "[?]", "a non-null array of undetermined length"),
    ARRAY_JUST_ONE_ELEMENT("ARRAY_JUST_ONE_ELEMENT", "[just one element]", "a non-null array with just one element"),
    ARRAY_MORE_THAN_AN_ELEMENT("ARRAY_MORE_THAN_AN_ELEMENT", "[more than an element]", "a non-null array within more than an element");

    private static final String CORE_SPECIAL_CHAR_START = "[##_CORE_##_][_";
    private static final String CORE_SPECIAL_CHAR_END = "_][##_CORE_##]";
    private String text;
    private String symbol;
    private String message;

    private SpecialTypeEnum(String text, String symbol, String message) {
        this.text = text;
        this.symbol = symbol;
        this.message = message;
    }

    String getMessage() {
        return this.message;
    }

    public String print() {
        return "\"[##_CORE_##_][_" + this.text + CORE_SPECIAL_CHAR_END + "\"";
    }

    String getText() {
        return this.text;
    }

    static final SpecialTypeEnum fromText(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        text = text.replace(CORE_SPECIAL_CHAR_START, "").replace(CORE_SPECIAL_CHAR_END, "").replace("\"", "").trim();
        for (SpecialTypeEnum specialTypeEnum : SpecialTypeEnum.values()) {
            if (!specialTypeEnum.text.equalsIgnoreCase(text)) continue;
            return specialTypeEnum;
        }
        return null;
    }

    static final String clean(String string) {
        for (SpecialTypeEnum specialTypeEnum : SpecialTypeEnum.values()) {
            string = string.replace(specialTypeEnum.print(), specialTypeEnum.symbol);
        }
        return string;
    }
}

