/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.java.process.fork;

import com.metaring.java.process.fork.JavaChildProcess;
import com.metaring.java.process.fork.PidRetriever;
import com.metaring.java.process.fork.ProcessKiller;
import com.metaring.java.process.fork.ProcessStreamReader;
import com.metaring.java.process.fork.ProcessWaiter;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class JavaProcessFork {
    private static final String JNA_JAR_FILE_PATH;
    private static final String JNA_JAR_FILE_NAME;
    private static final String JNA_PLATFORM_JAR_FILE_PATH;
    private static final String JNA_PLATFORM_JAR_FILE_NAME;
    private long jVMProcessPid;
    private long childJVMProcessPid;
    private InputStream childJVMProcessInputStream;
    private InputStream childJVMProcessErrorStream;
    private OutputStream childJVMProcessOutputStream;
    private boolean inputStreamRedirected;
    private boolean errorStreamRedirected;
    private String childJVMProcessCommand;
    private File childJVMProcessTempFolder;
    private long childProcessPid;
    private boolean childProcessPidObtainedByHandle;
    private String[] childProcessCommands;
    private File[] childProcessTempFiles;

    public static final JavaProcessFork fork(String command, File ... tempFilesToDelete) throws Exception {
        return JavaProcessFork.fork(new String[]{command}, true, true, tempFilesToDelete);
    }

    public static final JavaProcessFork forkNoRedirect(String command, File ... tempFilesToDelete) throws Exception {
        return JavaProcessFork.fork(new String[]{command}, false, false, tempFilesToDelete);
    }

    public static final JavaProcessFork fork(String command, boolean redirectInputStream, boolean redirectErrorStream, File ... tempFilesToDelete) throws Exception {
        return JavaProcessFork.fork(new String[]{command}, redirectInputStream, redirectErrorStream, tempFilesToDelete);
    }

    public static final JavaProcessFork fork(String[] commands, File ... tempFilesToDelete) throws Exception {
        return JavaProcessFork.fork(commands, true, true, tempFilesToDelete);
    }

    public static final JavaProcessFork forkNoRedirect(String[] commands, File ... tempFilesToDelete) throws Exception {
        return JavaProcessFork.fork(commands, false, false, tempFilesToDelete);
    }

    public static final JavaProcessFork fork(String[] commands, boolean redirectInputStream, boolean redirectErrorStream, File ... tempFilesToDelete) throws Exception {
        Path rootPath = Files.createTempDirectory(JavaProcessFork.class.getSimpleName(), new FileAttribute[0]);
        File root = rootPath.toFile();
        String rootString = root.getAbsolutePath().replace("\\", "/");
        if (!rootString.endsWith("/")) {
            rootString = rootString + "/";
        }
        String finalRootString = rootString;
        Path nameSpace = Files.createDirectories(rootPath.resolve(JavaProcessFork.class.getPackage().getName().replace(".", "/")), new FileAttribute[0]);
        JavaProcessFork.copyClass(nameSpace, JavaChildProcess.class);
        JavaProcessFork.copyClass(nameSpace, PidRetriever.class);
        JavaProcessFork.copyClass(nameSpace, ProcessStreamReader.class);
        JavaProcessFork.copyClass(nameSpace, ProcessWaiter.class);
        JavaProcessFork.copyClass(nameSpace, ProcessKiller.class);
        if (JavaChildProcess.IS_WINDOWS) {
            Files.copy(new FileInputStream(JNA_JAR_FILE_PATH), rootPath.resolve(JNA_JAR_FILE_NAME), new CopyOption[0]);
            Files.copy(new FileInputStream(JNA_PLATFORM_JAR_FILE_PATH), rootPath.resolve(JNA_PLATFORM_JAR_FILE_NAME), new CopyOption[0]);
        }
        StringBuilder sb = new StringBuilder(rootString);
        for (String command : commands) {
            sb.append("\n").append(command);
        }
        sb.append("\n").append(JavaChildProcess.CONMMAND_SEPARATOR);
        if (tempFilesToDelete != null && tempFilesToDelete.length > 0) {
            for (File tempFile : tempFilesToDelete) {
                sb.append("\n").append(tempFile.getAbsolutePath().replace("\\", "/"));
            }
        }
        Files.write(rootPath.resolve("context.txt"), sb.toString().getBytes(), new OpenOption[0]);
        String javaCommand = JavaChildProcess.QUOTES + System.getProperty("java.home").replace("\\", "/");
        if (!javaCommand.endsWith("/")) {
            javaCommand = javaCommand + "/";
        }
        javaCommand = javaCommand + "bin/java" + JavaChildProcess.QUOTES;
        ArrayList<String> javaCommands = new ArrayList<String>();
        javaCommands.add(javaCommand);
        javaCommands.add("-cp");
        javaCommands.add(JavaChildProcess.QUOTES + rootString + (JavaChildProcess.IS_WINDOWS ? File.pathSeparator + rootString + "*" : "") + JavaChildProcess.QUOTES);
        javaCommands.add(JavaChildProcess.class.getName());
        final Process process = Runtime.getRuntime().exec(javaCommands.toArray(new String[javaCommands.size()]));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    process.getOutputStream().write(JavaChildProcess.CLOSE_KEY.getBytes());
                    process.getOutputStream().flush();
                    process.getOutputStream().write("\n".getBytes());
                    process.getOutputStream().flush();
                    process.getOutputStream().close();
                    process.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JavaProcessFork javaProcessFork = new JavaProcessFork();
        javaProcessFork.jVMProcessPid = PidRetriever.getMyPid();
        javaProcessFork.childJVMProcessTempFolder = root;
        javaProcessFork.childJVMProcessCommand = javaCommand;
        javaProcessFork.childJVMProcessInputStream = process.getInputStream();
        javaProcessFork.childJVMProcessErrorStream = process.getErrorStream();
        javaProcessFork.childJVMProcessOutputStream = process.getOutputStream();
        javaProcessFork.inputStreamRedirected = redirectInputStream;
        javaProcessFork.errorStreamRedirected = redirectErrorStream;
        javaProcessFork.childJVMProcessPid = PidRetriever.getProcessPid(process).getPid();
        javaProcessFork.childProcessCommands = commands;
        javaProcessFork.childProcessTempFiles = tempFilesToDelete;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(javaProcessFork.childJVMProcessInputStream));
        javaProcessFork.childProcessPidObtainedByHandle = Boolean.parseBoolean(bufferedReader.readLine());
        javaProcessFork.childProcessPid = Long.parseLong(bufferedReader.readLine());
        new ProcessWaiter(process, (p, e) -> JavaChildProcess.exit(p, javaProcessFork.childProcessPidObtainedByHandle, javaProcessFork.childProcessPid, tempFilesToDelete, finalRootString, javaCommands, true));
        if (redirectInputStream) {
            new ProcessStreamReader(bufferedReader, System.out);
        }
        if (redirectErrorStream) {
            new ProcessStreamReader(new BufferedReader(new InputStreamReader(javaProcessFork.childJVMProcessErrorStream)), System.err);
        }
        return javaProcessFork;
    }

    private static final void copyClass(Path nameSpace, Class<?> clazz) throws Exception {
        Files.copy(JavaProcessFork.class.getClassLoader().getResourceAsStream(clazz.getName().replace(".", "/") + ".class"), nameSpace.resolve(clazz.getSimpleName() + ".class"), new CopyOption[0]);
    }

    private JavaProcessFork() {
    }

    public long getjVMProcessPid() {
        return this.jVMProcessPid;
    }

    public long getChildJVMProcessPid() {
        return this.childJVMProcessPid;
    }

    public InputStream getChildJVMProcessInputStream() {
        return this.childJVMProcessInputStream;
    }

    public InputStream getChildJVMProcessErrorStream() {
        return this.childJVMProcessErrorStream;
    }

    public OutputStream getChildJVMProcessOutputStream() {
        return this.childJVMProcessOutputStream;
    }

    public boolean isInputStreamRedirected() {
        return this.inputStreamRedirected;
    }

    public boolean isErrorStreamRedirected() {
        return this.errorStreamRedirected;
    }

    public String getChildJVMProcessCommand() {
        return this.childJVMProcessCommand;
    }

    public File getChildJVMProcessTempFolder() {
        return this.childJVMProcessTempFolder;
    }

    public boolean isChildProcessPidObtainedByHandle() {
        return this.childProcessPidObtainedByHandle;
    }

    public long getChildProcessPid() {
        return this.childProcessPid;
    }

    public String[] getChildProcessCommands() {
        return this.childProcessCommands;
    }

    public File[] getChildProcessTempFiles() {
        return this.childProcessTempFiles;
    }

    public void terminateProcess() {
        try {
            this.childJVMProcessOutputStream.write(JavaChildProcess.CLOSE_KEY.getBytes());
            this.childJVMProcessOutputStream.flush();
            this.childJVMProcessOutputStream.write("\n".getBytes());
            this.childJVMProcessOutputStream.flush();
            this.childJVMProcessOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String jnaPath = Native.class.getClassLoader().getResource(Native.class.getName().replace(".", "/") + ".class").toString();
        JNA_JAR_FILE_PATH = jnaPath = jnaPath.substring(0, jnaPath.indexOf("!")).replace("jar:file:", "").replace("\\", "/");
        JNA_JAR_FILE_NAME = jnaPath.substring(jnaPath.lastIndexOf("/") + 1);
        String jnaPlatformPath = WinNT.HANDLE.class.getClassLoader().getResource(WinNT.HANDLE.class.getName().replace(".", "/") + ".class").toString();
        JNA_PLATFORM_JAR_FILE_PATH = jnaPlatformPath = jnaPlatformPath.substring(0, jnaPlatformPath.indexOf("!")).replace("jar:file:", "").replace("\\", "/");
        JNA_PLATFORM_JAR_FILE_NAME = jnaPlatformPath.substring(jnaPlatformPath.lastIndexOf("/") + 1);
    }
}

