/*
 * Decompiled with CFR 0.152.
 */
package mob.push.api;

import java.util.List;
import mob.push.api.area.AreaClient;
import mob.push.api.device.DeviceClient;
import mob.push.api.exception.ApiException;
import mob.push.api.model.Area;
import mob.push.api.model.PushStats;
import mob.push.api.model.PushWork;
import mob.push.api.push.PushClient;
import mob.push.api.stats.StatsClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobPushClient {
    PushClient _pushClient = new PushClient();
    StatsClient _statsClient = new StatsClient();
    DeviceClient _deviceClient = new DeviceClient();
    AreaClient _areaClient = new AreaClient();

    public String push(PushWork pushWork) throws ApiException {
        return this._pushClient.sendPush(pushWork);
    }

    public PushWork pushById(String batchId) throws ApiException {
        return this._pushClient.getPushByBatchId(batchId);
    }

    public PushWork pushByWorkno(String workno) throws ApiException {
        return this._pushClient.getPushByWorkno(workno);
    }

    public PushStats statsById(String batchId) throws ApiException {
        return this._statsClient.getStatsByBatchId(batchId);
    }

    public PushStats statsByWorkno(String workno) throws ApiException {
        return this._statsClient.getStatsByWorkno(workno);
    }

    public String[] tagsByRegistrationId(String registrationId) throws ApiException {
        return this._deviceClient.getDeviceTags(registrationId);
    }

    public int tagsAdd(String[] tags, String registrationId) throws ApiException {
        return this._deviceClient.addDeviceTags(tags, registrationId);
    }

    public int tagsRemove(String[] tags, String registrationId) throws ApiException {
        return this._deviceClient.removeDeviceTags(tags, registrationId);
    }

    public int tagsClean(String registrationId) throws ApiException {
        return this._deviceClient.cleanDeviceTags(registrationId);
    }

    public String aliasByRegistrationId(String registrationId) throws ApiException {
        return this._deviceClient.getDeviceAlias(registrationId);
    }

    public int setAlias(String alias, String registrationId) throws ApiException {
        return this._deviceClient.setDeviceAlias(alias, registrationId);
    }

    public int cleanAlias(String registrationId) throws ApiException {
        return this._deviceClient.cleanDeviceAlias(registrationId);
    }

    public List<Area> area() throws ApiException {
        return this._areaClient.getArea();
    }

    public List<Area> area(String parentId) throws ApiException {
        return this._areaClient.getArea(parentId);
    }
}

