/*
 * Decompiled with CFR 0.152.
 */
package mob.push.api.device;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import mob.push.api.MobPushConfig;
import mob.push.api.exception.ApiException;
import mob.push.api.utils.HttpUtils;
import mob.push.api.utils.MobPushResult;

public class DeviceClient {
    public String getDeviceAlias(String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        String path = "http://api.push.mob.com/alias/" + registrationId;
        HttpUtils.GetEntity entity = new HttpUtils.GetEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, null).invoke();
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        if (result != null) {
            if (result.getRes() == null) {
                return null;
            }
            JSONObject json = (JSONObject)result.getRes();
            return json.getString("alias");
        }
        return null;
    }

    public int setDeviceAlias(String alias, String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        String path = "http://api.push.mob.com/alias";
        JSONObject json = new JSONObject();
        json.put("registrationId", (Object)registrationId);
        json.put("alias", (Object)alias);
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, json.toJSONString()).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        return result.getStatus();
    }

    public int cleanDeviceAlias(String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        String path = "http://api.push.mob.com/alias";
        JSONObject json = new JSONObject();
        json.put("registrationId", (Object)registrationId);
        json.put("alias", (Object)"");
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, json.toJSONString()).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        return result.getStatus();
    }

    public String[] getDeviceTags(String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        String path = "http://api.push.mob.com/tags/" + registrationId;
        HttpUtils.GetEntity entity = new HttpUtils.GetEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, null).invoke();
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        if (result != null) {
            if (result.getRes() == null) {
                return null;
            }
            JSONObject json = (JSONObject)result.getRes();
            if (json == null) {
                return null;
            }
            JSONArray array = json.getJSONArray("tags");
            if (array == null || array.isEmpty()) {
                return null;
            }
            Object[] tags = new String[array.size()];
            return (String[])array.toArray(tags);
        }
        return null;
    }

    public int addDeviceTags(String[] tags, String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        if (tags == null || tags.length < 1) {
            throw new ApiException(400, -1, "tags is null");
        }
        String path = "http://api.push.mob.com/tags";
        JSONObject json = new JSONObject();
        json.put("registrationId", (Object)registrationId);
        json.put("tags", (Object)tags);
        json.put("opType", (Object)1);
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, json.toJSONString()).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        return result.getStatus();
    }

    public int removeDeviceTags(String[] tags, String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        if (tags == null || tags.length < 1) {
            throw new ApiException(400, -1, "tags is null");
        }
        String path = "http://api.push.mob.com/tags";
        JSONObject json = new JSONObject();
        json.put("registrationId", (Object)registrationId);
        json.put("tags", (Object)tags);
        json.put("opType", (Object)2);
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, json.toJSONString()).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        return result.getStatus();
    }

    public int cleanDeviceTags(String registrationId) throws ApiException {
        if (registrationId == null || "".equals(registrationId.trim())) {
            throw new ApiException(400, -1, "registrationId is null");
        }
        String path = "http://api.push.mob.com/tags";
        JSONObject json = new JSONObject();
        json.put("registrationId", (Object)registrationId);
        json.put("opType", (Object)3);
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, json.toJSONString()).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        return result.getStatus();
    }
}

