/*
 * Decompiled with CFR 0.152.
 */
package mob.push.api.push;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import mob.push.api.MobPushConfig;
import mob.push.api.exception.ApiException;
import mob.push.api.model.PushWork;
import mob.push.api.utils.HttpUtils;
import mob.push.api.utils.MobPushResult;
import mob.push.api.utils.PlatEnum;
import mob.push.api.utils.PushTypeEnum;
import mob.push.api.utils.TargetEnum;

public class PushClient {
    public String createPushDefaultNotify(String workno, String content) throws ApiException {
        PushWork work = new PushWork(MobPushConfig.appkey, workno, PlatEnum.all.getCode(), content, PushTypeEnum.notify.getCode()).buildTarget(TargetEnum._1.getCode(), null, null, null, null, null);
        return this.sendPush(work);
    }

    public String createPushByDefaultCustom(String workno, String content) throws ApiException {
        PushWork work = new PushWork(MobPushConfig.appkey, workno, PlatEnum.all.getCode(), content, PushTypeEnum.custom.getCode()).buildTarget(TargetEnum._1.getCode(), null, null, null, null, null);
        return this.sendPush(work);
    }

    public String sendPush(PushWork pushWork) throws ApiException {
        String path = "http://api.push.mob.com/push";
        if (pushWork.getAppkey() == null) {
            pushWork.setAppkey(MobPushConfig.appkey);
        }
        if (pushWork.getContent() == null) {
            throw new ApiException(400, -1, "content is null");
        }
        if (pushWork.getTarget() == null) {
            throw new ApiException(400, -1, "target is null");
        }
        if (pushWork.getType() == null) {
            throw new ApiException(400, -1, "type is null");
        }
        HttpUtils.PostEntity entity = new HttpUtils.PostEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, JSON.toJSONString((Object)pushWork)).invoke(false);
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        if (result != null) {
            if (result.getRes() == null) {
                return null;
            }
            JSONObject json = (JSONObject)result.getRes();
            return json.getString("batchId");
        }
        return null;
    }

    public PushWork getPushByBatchId(String batchId) throws ApiException {
        if (batchId == null || "".equals(batchId.trim())) {
            throw new ApiException(400, -1, "batchId is null");
        }
        String path = "http://api.push.mob.com/push/id/" + batchId;
        return this.pullPush(path);
    }

    public PushWork getPushByWorkno(String workno) throws ApiException {
        if (workno == null || "".equals(workno.trim())) {
            throw new ApiException(400, -1, "workno is null");
        }
        String path = "http://api.push.mob.com/push/workno/" + workno;
        return this.pullPush(path);
    }

    private PushWork pullPush(String path) throws ApiException {
        HttpUtils.GetEntity entity = new HttpUtils.GetEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, null).invoke();
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        if (result != null) {
            if (result.getRes() == null) {
                return null;
            }
            JSONObject json = (JSONObject)result.getRes();
            PushWork work = (PushWork)json.toJavaObject(PushWork.class);
            return work;
        }
        return null;
    }
}

