/*
 * Decompiled with CFR 0.152.
 */
package mob.push.api.stats;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import mob.push.api.MobPushConfig;
import mob.push.api.exception.ApiException;
import mob.push.api.model.PushStats;
import mob.push.api.utils.HttpUtils;
import mob.push.api.utils.MobPushResult;

public class StatsClient {
    public PushStats getStatsByBatchId(String batchId) throws ApiException {
        if (batchId == null || "".equals(batchId.trim())) {
            throw new ApiException(400, -1, "batchId is null");
        }
        String path = "http://api.push.mob.com/stats/id/" + batchId;
        return this.pullStats(path);
    }

    public PushStats getStatsByWorkno(String workno) throws ApiException {
        if (workno == null || "".equals(workno.trim())) {
            throw new ApiException(400, -1, "workno is null");
        }
        String path = "http://api.push.mob.com/stats/workno/" + workno;
        return this.pullStats(path);
    }

    private PushStats pullStats(String path) throws ApiException {
        HttpUtils.GetEntity entity = new HttpUtils.GetEntity(path, MobPushConfig.appkey, MobPushConfig.appSecret, null).invoke();
        MobPushResult result = null;
        if (entity.getStatusCode() != 200) {
            result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
            throw new ApiException(entity.getStatusCode(), result.getStatus(), result.getError());
        }
        result = (MobPushResult)JSON.toJavaObject((JSON)JSON.parseObject((String)entity.getResp()), MobPushResult.class);
        if (result != null) {
            if (result.getRes() == null) {
                return null;
            }
            JSONObject json = (JSONObject)result.getRes();
            PushStats stats = (PushStats)json.toJavaObject(PushStats.class);
            return stats;
        }
        return null;
    }
}

