/*
 * Decompiled with CFR 0.152.
 */
package mob.push.api.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import mob.push.api.exception.ApiException;
import mob.push.api.utils.MD5;
import mob.push.api.utils.MobHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static void closeConn(CloseableHttpClient httpClient, CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetEntity {
        private String httpUrl;
        private int statusCode;
        private String resp;
        private String appkey;
        private String appSecret;
        private Map<String, Object> par;

        public GetEntity(String httpUrl, String appkey, String appSecret, Map<String, Object> par) {
            this.httpUrl = httpUrl;
            this.par = par;
            this.appkey = appkey;
            this.appSecret = appSecret;
        }

        public String sort() {
            StringBuffer buffer = new StringBuffer();
            if (this.par == null) {
                return null;
            }
            ArrayList<Map.Entry<String, Object>> keys = new ArrayList<Map.Entry<String, Object>>(this.par.entrySet());
            Collections.sort(keys, new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                    return o1.getKey().toString().compareTo(o2.getKey());
                }
            });
            for (Map.Entry entry : keys) {
                buffer.append((String)entry.getKey() + "=" + entry.getValue() + "&");
            }
            if (buffer.length() > 0) {
                return buffer.toString().substring(0, buffer.length() - 1);
            }
            return buffer.toString();
        }

        public GetEntity invoke() throws ApiException {
            if (MobHelper.isBlank(this.appkey) || MobHelper.isBlank(this.appSecret)) {
                throw new ApiException(400, -1, "appkey or appSecret is null,Please go to MobPushConfig to set them");
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(15000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();
            if (this.par != null) {
                this.httpUrl = this.httpUrl + this.sort();
            }
            HttpGet httpGet = new HttpGet(this.httpUrl);
            httpGet.setHeader("sign", this.serverSign(this.sort(), this.appSecret));
            httpGet.setHeader("key", this.appkey);
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            try {
                httpClient = HttpClients.createDefault();
                httpGet.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)httpGet);
                entity = response.getEntity();
                this.resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                this.statusCode = response.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                try {
                    throw new ApiException(400, -1, e.toString());
                }
                catch (Throwable throwable) {
                    HttpUtils.closeConn(httpClient, response);
                    throw throwable;
                }
            }
            HttpUtils.closeConn(httpClient, response);
            return this;
        }

        protected String serverSign(String decodeData, String appSecret) {
            if (decodeData == null || decodeData.equals("")) {
                return MD5.hash(appSecret, MobHelper.CHARSET_UTF8);
            }
            return MD5.hash(decodeData + appSecret, MobHelper.CHARSET_UTF8);
        }

        public String getAppkey() {
            return this.appkey;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResp() {
            return this.resp;
        }

        public String getAppSecret() {
            return this.appSecret;
        }
    }

    public static class PostEntity {
        private String httpUrl;
        private int statusCode;
        private String resp;
        private String appkey;
        private String appSecret;
        private String orgData;

        public PostEntity(String httpUrl, String appkey, String appSecret, String orgData) {
            this.httpUrl = httpUrl;
            this.orgData = orgData;
            this.appkey = appkey;
            this.appSecret = appSecret;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResp() {
            return this.resp;
        }

        public String getAppkey() {
            return this.appkey;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        protected String serverSign(String decodeData, String appSecret) {
            return MD5.hash(decodeData + appSecret, MobHelper.CHARSET_UTF8);
        }

        public PostEntity invoke(boolean useGzip) throws ApiException {
            if (MobHelper.isBlank(this.appkey) || MobHelper.isBlank(this.appSecret)) {
                throw new ApiException(400, -1, "appkey or appSecret is null,Please go to MobPushConfig to set them");
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
            HttpPost httpPost = new HttpPost(this.httpUrl);
            httpPost.setHeader("sign", this.serverSign(this.orgData, this.appSecret));
            httpPost.setHeader("key", this.appkey);
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            try {
                try {
                    httpClient = HttpClients.createDefault();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                httpPost.setConfig(requestConfig);
                if (!useGzip) {
                    httpPost.setEntity((HttpEntity)new StringEntity(this.orgData, "UTF-8"));
                } else {
                    httpPost.setHeader("Content-Encoding", "gzip");
                    ByteArrayOutputStream originalContent = new ByteArrayOutputStream();
                    originalContent.write(this.orgData.getBytes(Charset.forName("UTF-8")));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
                    originalContent.writeTo(gzipOut);
                    gzipOut.finish();
                    httpPost.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray(), ContentType.TEXT_PLAIN));
                }
                response = httpClient.execute((HttpUriRequest)httpPost);
                entity = response.getEntity();
                this.resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                this.statusCode = response.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                try {
                    throw new ApiException(400, -1, e.toString());
                }
                catch (Throwable throwable) {
                    HttpUtils.closeConn(httpClient, response);
                    throw throwable;
                }
            }
            HttpUtils.closeConn(httpClient, response);
            return this;
        }
    }
}

