/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.executor;

import com.morethanheroic.taskforce.executor.context.JobContext;
import com.morethanheroic.taskforce.executor.task.TaskExecutor;
import com.morethanheroic.taskforce.job.Job;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobExecutor.class);

    public void execute(Job job) {
        job.initialize();
        while (!job.isFinished()) {
            try {
                this.processEntry(job);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while generating element!", e);
            }
        }
        job.cleanup();
    }

    public Future<?> executeAsync(Job job) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return executorService.submit(() -> this.execute(job));
    }

    private void processEntry(Job job) {
        TaskExecutor taskExecutor = job.getTaskExecutor();
        JobContext jobContext = job.getJobContext();
        Optional<?> generationResult = job.getGenerator().generate();
        if (!generationResult.isPresent()) {
            jobContext.setLastItemReached();
        } else {
            taskExecutor.submitTasks(generationResult.get(), job.getTaskDescriptors(), job.getSink());
        }
    }
}

