/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.executor.task;

import com.morethanheroic.taskforce.executor.item.WorkItemProcessor;
import com.morethanheroic.taskforce.sink.Sink;
import com.morethanheroic.taskforce.task.domain.TaskDescriptor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutor.class);
    private final Semaphore semaphore;
    private final ExecutorService taskExecutorService;
    private final WorkItemProcessor workItemProcessor;
    private final int threadCount;

    private TaskExecutor(int threadCount) {
        this.threadCount = threadCount;
        this.semaphore = new Semaphore(threadCount);
        this.taskExecutorService = Executors.newFixedThreadPool(threadCount);
        this.workItemProcessor = new WorkItemProcessor();
    }

    public void submitTasks(Object rawWorkItem, List<TaskDescriptor<?, ?>> taskDescriptors, Sink<?> sink) {
        this.acquireWorkingSlot();
        this.taskExecutorService.submit(() -> this.processWorkItem(rawWorkItem, taskDescriptors, sink));
    }

    public void shutdown() {
        this.taskExecutorService.shutdown();
    }

    public void waitUntilFinished() {
        try {
            this.semaphore.acquire(this.threadCount);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to wait until all tasks are finished!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkItem(Object rawWorkItem, List<TaskDescriptor<?, ?>> taskDescriptors, Sink<?> sink) {
        try {
            this.workItemProcessor.processWorkItem(rawWorkItem, taskDescriptors, sink);
        }
        catch (Exception e) {
            log.warn("Error while processing tasks!", (Throwable)e);
        }
        finally {
            this.releaseWorkingSlot();
        }
    }

    private void acquireWorkingSlot() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to acquire working slot!");
        }
    }

    private void releaseWorkingSlot() {
        this.semaphore.release();
    }

    public static TaskExecutorBuilder builder() {
        return new TaskExecutorBuilder();
    }

    @Generated
    public int getThreadCount() {
        return this.threadCount;
    }

    public static class TaskExecutorBuilder {
        private int threadCount;

        public TaskExecutorBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public TaskExecutor build() {
            return new TaskExecutor(this.threadCount);
        }
    }
}

