/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.job.builder;

import com.morethanheroic.taskforce.executor.context.JobContext;
import com.morethanheroic.taskforce.executor.task.TaskExecutor;
import com.morethanheroic.taskforce.job.Job;
import com.morethanheroic.taskforce.job.SimpleJob;
import com.morethanheroic.taskforce.job.builder.domain.TaskStageJobContext;
import java.util.Collections;
import lombok.Generated;

public class JobFinalPhaseBuilder {
    private final TaskStageJobContext taskStageJobContext;
    private int threadCount;

    public JobFinalPhaseBuilder withThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public Job build() {
        TaskExecutor taskExecutor = this.newExecutor(this.threadCount);
        JobContext jobContext = this.newContext();
        return new SimpleJob(this.taskStageJobContext.getGenerator(), Collections.unmodifiableList(this.taskStageJobContext.getTaskDescriptors()), this.taskStageJobContext.getSink(), taskExecutor, jobContext);
    }

    private TaskExecutor newExecutor(int threadCount) {
        if (threadCount == 0) {
            return TaskExecutor.builder().threadCount(Runtime.getRuntime().availableProcessors()).build();
        }
        return TaskExecutor.builder().threadCount(threadCount).build();
    }

    private JobContext newContext() {
        return JobContext.builder().build();
    }

    @Generated
    public JobFinalPhaseBuilder(TaskStageJobContext taskStageJobContext) {
        this.taskStageJobContext = taskStageJobContext;
    }
}

