/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.job.builder;

import com.morethanheroic.taskforce.job.builder.JobFinalPhaseBuilder;
import com.morethanheroic.taskforce.job.builder.domain.GeneratorStageJobContext;
import com.morethanheroic.taskforce.job.builder.domain.TaskStageJobContext;
import com.morethanheroic.taskforce.sink.Sink;
import com.morethanheroic.taskforce.task.Task;
import com.morethanheroic.taskforce.task.decorator.StatisticsDecoratorTask;
import com.morethanheroic.taskforce.task.domain.TaskContext;
import com.morethanheroic.taskforce.task.domain.TaskDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class JobTaskPhaseBuilder<NEXT_INPUT> {
    private final GeneratorStageJobContext jobContext;
    private final List<TaskDescriptor<?, ?>> taskDescriptors = new ArrayList();

    public <OUTPUT> JobTaskPhaseBuilder<OUTPUT> task(Task<NEXT_INPUT, OUTPUT> task) {
        return this.task(task, TaskContext.builder().build());
    }

    public <OUTPUT> JobTaskPhaseBuilder<OUTPUT> task(String taskName, Task<NEXT_INPUT, OUTPUT> task) {
        return this.task(taskName, task, TaskContext.builder().build());
    }

    public <OUTPUT> JobTaskPhaseBuilder<OUTPUT> task(Task<NEXT_INPUT, OUTPUT> task, TaskContext taskContext) {
        String taskName = UUID.randomUUID().toString();
        return this.task(taskName, task, taskContext);
    }

    public <OUTPUT> JobTaskPhaseBuilder<OUTPUT> task(String taskName, Task<NEXT_INPUT, OUTPUT> task, TaskContext taskContext) {
        Task<NEXT_INPUT, OUTPUT> resultTask = task;
        if (taskContext.isStatisticsCollectionEnabled() || taskContext.isStatisticsReportingEnabled()) {
            resultTask = new StatisticsDecoratorTask<NEXT_INPUT, OUTPUT>(taskName, task, taskContext.isStatisticsReportingEnabled(), taskContext.getStatisticsReportingRate());
        }
        this.taskDescriptors.add(TaskDescriptor.builder().taskName(taskName).task(resultTask).build());
        return this;
    }

    public JobFinalPhaseBuilder sink(Sink<NEXT_INPUT> sink) {
        return new JobFinalPhaseBuilder(TaskStageJobContext.builder().generator(this.jobContext.getGenerator()).taskDescriptors(this.taskDescriptors).sink(sink).build());
    }

    @Generated
    public JobTaskPhaseBuilder(GeneratorStageJobContext jobContext) {
        this.jobContext = jobContext;
    }
}

