/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.sink;

import com.morethanheroic.taskforce.sink.Sink;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSink<INPUT>
implements Sink<INPUT> {
    private final Logger log = LoggerFactory.getLogger(LoggingSink.class);
    private final String format;
    private final boolean logEmpty;

    public static <WORK_ITEM_TYPE> LoggingSink<WORK_ITEM_TYPE> of(String format) {
        return new LoggingSink(format, true);
    }

    public static <WORK_ITEM_TYPE> LoggingSink<WORK_ITEM_TYPE> of(String format, boolean logEmpty) {
        return new LoggingSink(format, logEmpty);
    }

    @Override
    public void consume(INPUT input) {
        if (!this.logEmpty && this.isEmptyInput(input)) {
            return;
        }
        this.log.info(this.format, input);
    }

    private boolean isEmptyInput(INPUT input) {
        return input == null || this.isEmptyCollection(input) || this.isEmptyString(input);
    }

    private boolean isEmptyCollection(INPUT input) {
        return input instanceof Collection && ((Collection)input).size() == 0;
    }

    private boolean isEmptyString(INPUT input) {
        return input instanceof String && ((String)input).isEmpty();
    }

    @Generated
    private LoggingSink(String format, boolean logEmpty) {
        this.format = format;
        this.logEmpty = logEmpty;
    }
}

