/*
 * Decompiled with CFR 0.152.
 */
package com.morethanheroic.taskforce.task.decorator;

import com.morethanheroic.taskforce.task.Task;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsDecoratorTask<INPUT, OUTPUT>
implements Task<INPUT, OUTPUT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsDecoratorTask.class);
    private final String delegateName;
    private final Task<INPUT, OUTPUT> delegate;
    private final boolean reportingEnabled;
    private final int reportingRate;
    private final AtomicLong totalItemCount = new AtomicLong();
    private final LongAdder successfulItemCount = new LongAdder();
    private final LongAdder unsuccessfulItemCount = new LongAdder();

    @Override
    public Optional<OUTPUT> execute(INPUT input) {
        long totalCount = this.totalItemCount.incrementAndGet();
        try {
            Optional<OUTPUT> result = this.delegate.execute(input);
            this.successfulItemCount.increment();
            this.doLogging(totalCount);
            return result;
        }
        catch (Exception e) {
            this.unsuccessfulItemCount.increment();
            this.doLogging(totalCount);
            throw e;
        }
    }

    private void doLogging(long totalResultCount) {
        if (this.reportingEnabled && totalResultCount % (long)this.reportingRate == 0L) {
            long successfulCount = this.successfulItemCount.sum();
            long unsuccessfulCount = this.unsuccessfulItemCount.sum();
            long totalInvocation = successfulCount + unsuccessfulCount;
            log.info("The '{}' task ran {} times. Successful invocations: {} unsuccessful invocations: {}.", new Object[]{this.delegateName, totalInvocation, successfulCount, unsuccessfulCount});
        }
    }

    @Generated
    public StatisticsDecoratorTask(String delegateName, Task<INPUT, OUTPUT> delegate, boolean reportingEnabled, int reportingRate) {
        this.delegateName = delegateName;
        this.delegate = delegate;
        this.reportingEnabled = reportingEnabled;
        this.reportingRate = reportingRate;
    }

    @Generated
    public String getDelegateName() {
        return this.delegateName;
    }

    @Generated
    public Task<INPUT, OUTPUT> getDelegate() {
        return this.delegate;
    }

    @Generated
    public boolean isReportingEnabled() {
        return this.reportingEnabled;
    }

    @Generated
    public int getReportingRate() {
        return this.reportingRate;
    }
}

