/*
 * Decompiled with CFR 0.152.
 */
package com.mozu.api.cache.impl;

import com.mozu.api.cache.CacheManager;
import com.mozu.api.cache.CacheManagerFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerImpl<T>
implements CacheManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(CacheManagerImpl.class);
    private JCS jcsCache;
    private boolean _isInitialized = false;

    public void startCache() {
        try {
            this.jcsCache = JCS.getInstance((String)"mozuCache");
            this._isInitialized = true;
        }
        catch (CacheException e) {
            logger.warn("Cache initialization failed");
            e.printStackTrace();
        }
        CacheManagerFactory.setCacheManager((CacheManager)this);
        logger.info("Cache manager initialized");
    }

    public void put(String id, T cacheObject) {
        if (!this._isInitialized) {
            return;
        }
        try {
            this.jcsCache.put((Object)id, cacheObject);
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }

    public T get(String id) {
        if (!this._isInitialized) {
            return null;
        }
        return (T)this.jcsCache.get((Object)id);
    }

    public void remove(String id) {
        if (!this._isInitialized) {
            return;
        }
        try {
            this.jcsCache.remove((Object)id);
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }
}

