/*
 * Decompiled with CFR 0.152.
 */
package com.mozu.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mozu.api.ApiContext;
import com.mozu.api.ApiError;
import com.mozu.api.ApiException;
import com.mozu.api.MozuClient;
import com.mozu.api.MozuConfig;
import com.mozu.api.MozuUrl;
import com.mozu.api.cache.CacheManager;
import com.mozu.api.cache.CacheManagerFactory;
import com.mozu.api.cache.impl.CacheItem;
import com.mozu.api.contracts.tenant.Tenant;
import com.mozu.api.resources.platform.TenantResource;
import com.mozu.api.security.AppAuthenticator;
import com.mozu.api.security.AuthTicket;
import com.mozu.api.security.AuthenticationScope;
import com.mozu.api.security.CustomerAuthenticator;
import com.mozu.api.security.UserAuthenticator;
import com.mozu.api.utils.HttpHelper;
import com.mozu.api.utils.JsonUtils;
import com.mozu.api.utils.MozuHttpClientPool;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;

public class MozuClientImpl<TResult>
implements MozuClient<TResult> {
    private static final ObjectMapper mapper = JsonUtils.initObjectMapper();
    private ApiContext apiContext = null;
    private String baseAddress = null;
    private CloseableHttpResponse httpResponseMessage = null;
    private String httpContent = null;
    private InputStream streamContent = null;
    private String verb = null;
    private MozuUrl resourceUrl = null;
    private HashMap<String, String> headers = new HashMap();
    private final Class<TResult> responseType;
    private CacheItem cacheItem = null;
    private String cacheKey = null;

    public MozuClientImpl() {
        this.responseType = null;
    }

    public MozuClientImpl(Class<TResult> responseType) throws Exception {
        this.responseType = responseType;
    }

    public void setContext(ApiContext apiContext) {
        this.apiContext = apiContext;
        if (apiContext != null) {
            if (apiContext.getTenantId() > 0) {
                this.addHeader("x-vol-tenant", String.valueOf(apiContext.getTenantId()));
            }
            if (apiContext.getSiteId() != null && apiContext.getSiteId() > 0) {
                this.addHeader("x-vol-site", String.valueOf(apiContext.getSiteId()));
            }
            if (apiContext.getMasterCatalogId() != null && apiContext.getMasterCatalogId() > 0) {
                this.addHeader("x-vol-master-catalog", String.valueOf(apiContext.getMasterCatalogId()));
            }
            if (apiContext.getCatalogId() != null && apiContext.getCatalogId() > 0) {
                this.addHeader("x-vol-catalog", String.valueOf(apiContext.getCatalogId()));
            }
            if (apiContext.getLocale() != null) {
                this.addHeader("x-vol-locale", String.valueOf(apiContext.getLocale()));
            }
            if (apiContext.getCurrency() != null) {
                this.addHeader("x-vol-currency", String.valueOf(apiContext.getCurrency()));
            }
            if (apiContext.getCustomHeaders() != null) {
                for (Map.Entry headerEntry : apiContext.getCustomHeaders().entrySet()) {
                    this.addHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
                }
            }
        }
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public void setResourceUrl(MozuUrl resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public <TBody> void setBody(TBody body) throws JsonProcessingException {
        this.httpContent = mapper.writeValueAsString(body);
    }

    public void setBody(InputStream body) throws JsonProcessingException {
        this.streamContent = body;
    }

    public void setBody(String body) {
        this.httpContent = body;
    }

    public String getStringResult() throws Exception {
        return this.stringContent();
    }

    public TResult getResult() throws Exception {
        InputStream tResult = null;
        try {
            if (this.httpResponseMessage.getStatusLine().getStatusCode() == 404) {
                TResult TResult = null;
                return TResult;
            }
            if (this.responseType != null) {
                String className = this.responseType.getName();
                tResult = className.equals(InputStream.class.getName()) ? this.httpResponseMessage.getEntity().getContent() : (this.cacheItem != null ? this.deserialize(this.cacheItem.getContent(), this.responseType) : this.deserialize(this.getStringResult(), this.responseType));
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)this.httpResponseMessage.getEntity());
            this.httpResponseMessage.close();
        }
        return (TResult)tResult;
    }

    protected void validateContext() throws Exception {
        AppAuthenticator appAuthenticator = AppAuthenticator.getInstance();
        if (appAuthenticator == null) {
            throw new ApiException("Application has not been authorized to access Mozu.");
        }
        if (this.resourceUrl.getLocation() == MozuUrl.UrlLocation.TENANT_POD) {
            if (this.apiContext == null || this.apiContext.getTenantId() <= 0) {
                throw new ApiException("TenantId is missing");
            }
            if (StringUtils.isBlank((String)this.apiContext.getTenantUrl())) {
                TenantResource tenantResource = new TenantResource();
                Tenant tenant = tenantResource.getTenant(this.apiContext.getTenantId());
                if (tenant == null) {
                    throw new ApiException("Tenant " + this.apiContext.getTenantId() + " Not found");
                }
                this.baseAddress = HttpHelper.getUrl((String)tenant.getDomain());
            } else {
                this.baseAddress = this.apiContext.getTenantUrl();
            }
        } else if (this.resourceUrl.getLocation() == MozuUrl.UrlLocation.HOME_POD) {
            if (StringUtils.isBlank((String)MozuConfig.getBaseUrl())) {
                throw new ApiException("Authentication.Instance.BaseUrl is missing");
            }
            this.baseAddress = MozuConfig.getBaseUrl();
        } else if (this.resourceUrl.getLocation() == MozuUrl.UrlLocation.PCI_POD) {
            if (this.apiContext == null || this.apiContext.getTenantId() < 0) {
                throw new ApiException("TenantId is missing");
            }
            if (StringUtils.isBlank((String)MozuConfig.getBasePciUrl())) {
                throw new ApiException("Authentication.Instance.BasePciUrl is missing");
            }
            Tenant tenant = this.getTenant(this.apiContext.getTenantId());
            this.baseAddress = tenant.getIsDevTenant() != false ? MozuConfig.getBaseDevPciUrl() : MozuConfig.getBasePciUrl();
        }
    }

    private Tenant getTenant(Integer tenantId) throws Exception {
        TenantResource tenantResource = new TenantResource();
        Tenant tenant = tenantResource.getTenant(tenantId);
        if (tenant == null) {
            throw new ApiException("Tenant " + tenantId + " Not found");
        }
        return tenant;
    }

    public void executeRequest() throws Exception {
        this.validateContext();
        CloseableHttpClient client = MozuHttpClientPool.getInstance().getHttpClient();
        BasicHttpEntityEnclosingRequest request = this.buildRequest();
        URL url = new URL(this.baseAddress);
        String hostNm = url.getHost();
        int port = url.getPort();
        String sche = url.getProtocol();
        HttpHost httpHost = new HttpHost(hostNm, port, sche);
        this.setCacheKey(request);
        CacheManager cache = CacheManagerFactory.getCacheManager();
        if (cache != null) {
            this.cacheItem = (CacheItem)cache.get(this.cacheKey);
            if (this.cacheItem != null) {
                request.addHeader("If-None-Match", this.cacheItem.geteTag());
            }
        }
        this.httpResponseMessage = client.execute(httpHost, (HttpRequest)request);
        try {
            this.ensureSuccess((HttpResponse)this.httpResponseMessage, request.getRequestLine());
            this.setCache();
        }
        catch (Exception e) {
            EntityUtils.consume((HttpEntity)this.httpResponseMessage.getEntity());
            this.httpResponseMessage.close();
            throw e;
        }
    }

    public TResult executePostRequest(Object bodyObject, String resourceUrl, Map<String, String> headers) {
        return this.executeRequest(bodyObject, (HttpEntityEnclosingRequestBase)new HttpPost(resourceUrl), headers);
    }

    public TResult executePutRequest(Object bodyObject, String resourceUrl, Map<String, String> headers) {
        return this.executeRequest(bodyObject, (HttpEntityEnclosingRequestBase)new HttpPut(resourceUrl), headers);
    }

    public void executeDeleteRequest(String resourceUrl, Map<String, String> headers) throws ApiException {
        HttpDelete delete = new HttpDelete(resourceUrl);
        delete.setHeader("Accept", "application/json");
        delete.setHeader("Content-type", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                delete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.executeRequest((HttpRequestBase)delete);
        }
        catch (Exception ioe) {
            throw new ApiException("Exception occurred while authenticating user: " + ioe.getMessage());
        }
    }

    private void executeRequest(HttpRequestBase request) throws Exception {
        CloseableHttpClient client = MozuHttpClientPool.getInstance().getHttpClient();
        this.httpResponseMessage = client.execute((HttpUriRequest)request);
        try {
            this.ensureSuccess((HttpResponse)this.httpResponseMessage, request.getRequestLine());
        }
        catch (Exception e) {
            EntityUtils.consume((HttpEntity)this.httpResponseMessage.getEntity());
            this.httpResponseMessage.close();
            throw e;
        }
    }

    private TResult executeRequest(Object bodyObject, HttpEntityEnclosingRequestBase request, Map<String, String> headers) {
        TResult result = null;
        try {
            String body = mapper.writeValueAsString(bodyObject);
            StringEntity se = new StringEntity(body);
            request.setEntity((HttpEntity)se);
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-type", "application/json");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new ApiException("JSON error proccessing authentication: " + uee.getMessage());
        }
        catch (JsonProcessingException jpe) {
            throw new ApiException("JSON error proccessing authentication: " + jpe.getMessage());
        }
        try {
            this.executeRequest((HttpRequestBase)request);
            result = this.getResult();
        }
        catch (ApiException ae) {
            throw ae;
        }
        catch (Exception ioe) {
            throw new ApiException("Exception occurred while authenticating application: " + ioe.getMessage());
        }
        return result;
    }

    public void cleanupHttpConnection() throws Exception {
        if (this.httpResponseMessage != null) {
            EntityUtils.consume((HttpEntity)this.httpResponseMessage.getEntity());
            this.httpResponseMessage.close();
        }
    }

    private void setCacheKey(BasicHttpEntityEnclosingRequest request) {
        StringBuilder key = new StringBuilder();
        key.append(request.getRequestLine().getUri().toString());
        if (this.apiContext != null) {
            String dataViewMode;
            if (this.apiContext.getSiteId() != null) {
                key.append(this.apiContext.getSiteId());
            }
            if (!StringUtils.isEmpty((String)this.apiContext.getCurrency())) {
                key.append(this.apiContext.getCurrency());
            }
            if (!StringUtils.isEmpty((String)this.apiContext.getLocale())) {
                key.append(this.apiContext.getLocale());
            }
            if (this.apiContext.getMasterCatalogId() != null) {
                key.append(this.apiContext.getMasterCatalogId());
            }
            if (this.apiContext.getCatalogId() != null) {
                key.append(this.apiContext.getCatalogId());
            }
            if (!StringUtils.isEmpty((String)(dataViewMode = this.getHeaderValue("x-vol-dataview-mode", (HttpMessage)request)))) {
                key.append(dataViewMode);
            }
        }
        this.cacheKey = key.toString();
    }

    private void setCache() throws Exception {
        CacheManager cache;
        String eTag = this.getHeaderValue("ETag", (HttpMessage)this.httpResponseMessage);
        if ((this.cacheItem == null || this.httpResponseMessage.getStatusLine().getStatusCode() != 304) && StringUtils.isNotEmpty((String)eTag) && this.httpResponseMessage.getStatusLine().getStatusCode() != 404 && (cache = CacheManagerFactory.getCacheManager()) != null) {
            this.cacheItem = new CacheItem();
            this.cacheItem.seteTag(eTag);
            this.cacheItem.setKey(this.cacheKey);
            this.cacheItem.setContent(this.stringContent());
            cache.put(this.cacheKey, (Object)this.cacheItem);
        }
    }

    private TResult deserialize(String jsonString, Class<TResult> cls) throws Exception {
        return (TResult)mapper.readValue(jsonString, cls);
    }

    private String stringContent() throws Exception {
        HttpEntity httpEntity = this.httpResponseMessage.getEntity();
        InputStream stream = httpEntity.getContent();
        return IOUtils.toString((InputStream)stream, (String)"UTF-8");
    }

    private BasicHttpEntityEnclosingRequest buildRequest() throws Exception {
        String url = this.baseAddress + this.resourceUrl.getUrl();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest(this.verb, url);
        if (this.verb.equals("POST") || this.verb.equals("PUT")) {
            if (StringUtils.isNotBlank((String)this.httpContent)) {
                request.setHeader("Accept", "application/json");
                StringEntity entity = new StringEntity(this.httpContent, Consts.UTF_8);
                request.setEntity((HttpEntity)entity);
            } else if (this.streamContent != null) {
                long length = -1L;
                if (this.streamContent instanceof FileInputStream) {
                    if (((FileInputStream)this.streamContent).getChannel() != null) {
                        length = ((FileInputStream)this.streamContent).getChannel().size();
                    }
                } else {
                    throw new UnsupportedOperationException("The InputStream is not supported. It must be an instance of FileInputStream.");
                }
                InputStreamEntity entity = new InputStreamEntity(this.streamContent, length);
                request.setEntity((HttpEntity)entity);
            }
        }
        if (!this.headers.containsKey("Content-Type")) {
            request.setHeader("Content-type", "application/json; charset=utf-8");
        }
        if (this.apiContext != null && this.apiContext.getUserAuthTicket() != null) {
            this.setUserClaims();
        }
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
        request.addHeader("x-vol-app-claims", AppAuthenticator.addAuthHeader());
        request.addHeader("x-vol-version", "1.1840.18281.0");
        return request;
    }

    private void setUserClaims() {
        AuthTicket newAuthTicket = null;
        newAuthTicket = this.apiContext.getUserAuthTicket().getScope() == AuthenticationScope.Customer ? CustomerAuthenticator.ensureAuthTicket((AuthTicket)this.apiContext.getUserAuthTicket(), (Integer)this.apiContext.getTenantId(), (Integer)this.apiContext.getSiteId()) : UserAuthenticator.ensureAuthTicket((AuthTicket)this.apiContext.getUserAuthTicket());
        if (newAuthTicket != null) {
            this.apiContext.getUserAuthTicket().setAccessToken(newAuthTicket.getAccessToken());
            this.apiContext.getUserAuthTicket().setAccessTokenExpiration(newAuthTicket.getAccessTokenExpiration());
        }
        this.addHeader("x-vol-user-claims", this.apiContext.getUserAuthTicket().getAccessToken());
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    protected void ensureSuccess(HttpResponse response, RequestLine requestLine) throws ApiException {
        ApiError apiError;
        int statusCode;
        block9: {
            statusCode = response.getStatusLine().getStatusCode();
            String correlationId = this.getHeaderValue("x-vol-correlation", (HttpMessage)response);
            if (statusCode == 304 || statusCode >= 200 && statusCode <= 300) {
                return;
            }
            apiError = new ApiError();
            apiError.setCorrelationId(correlationId);
            if (statusCode == 404 && StringUtils.isEmpty((String)correlationId)) {
                apiError.setMessage(requestLine.getUri().toString() + " not found");
            } else {
                if (!StringUtils.isEmpty((String)correlationId)) {
                    try {
                        apiError = (ApiError)mapper.readValue(this.stringContent(), ApiError.class);
                        apiError.setCorrelationId(correlationId);
                        if (apiError.getErrorCode().equals("ITEM_NOT_FOUND") && statusCode == 404 && StringUtils.endsWithIgnoreCase((String)"get", (String)requestLine.getMethod())) {
                            return;
                        }
                        break block9;
                    }
                    catch (JsonProcessingException jpe) {
                        throw new ApiException("An error has occurred. Status Code: " + statusCode + " Status Message: " + response.getStatusLine().getReasonPhrase(), statusCode);
                    }
                    catch (IOException ioe) {
                        throw new ApiException("An error occurred. Status Code: " + statusCode + " Status Message: " + response.getStatusLine().getReasonPhrase(), statusCode);
                    }
                    catch (Exception e) {
                        throw new ApiException("An error occurred. Status Code: " + statusCode + " Status Message: " + response.getStatusLine().getReasonPhrase(), statusCode);
                    }
                }
                apiError.setMessage("Unknown Error");
            }
        }
        throw new ApiException(MozuClientImpl.getMozuErrorMessage(apiError), apiError, statusCode);
    }

    private static String getMozuErrorMessage(ApiError apiError) {
        StringBuilder errorMessage = new StringBuilder("Error returned from Mozu. Correlation ID: ");
        errorMessage.append(apiError.getCorrelationId());
        errorMessage.append(".  Message: ");
        if (StringUtils.isNotBlank((String)apiError.getMessage())) {
            errorMessage.append(apiError.getMessage());
        } else if (apiError.getExceptionDetail() != null && StringUtils.isNotBlank((String)apiError.getExceptionDetail().getMessage())) {
            errorMessage.append(apiError.getExceptionDetail().getMessage());
        } else if (apiError.getItems().size() > 0) {
            for (ApiError.Item item : apiError.getItems()) {
                errorMessage.append(item.getMessage());
                errorMessage.append(". Error Code: ").append(item.getErrorCode());
            }
        } else {
            errorMessage.append("No error message returned from Mozu.");
        }
        return errorMessage.toString();
    }

    private String getHeaderValue(String header, HttpMessage httpMessage) {
        if (httpMessage.containsHeader(header)) {
            return httpMessage.getFirstHeader(header).getValue();
        }
        return null;
    }
}

