/*
 * Decompiled with CFR 0.152.
 */
package com.mozu.api.utils;

import com.mozu.api.MozuConfig;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MozuHttpClientPool {
    private static final Logger logger = LoggerFactory.getLogger(MozuHttpClientPool.class);
    private static MozuHttpClientPool mozuHttpClientPool = null;
    private final CloseableHttpClient threadSafeClient;
    private final IdleConnectionMonitorThread monitor;

    private MozuHttpClientPool() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(MozuConfig.getMaxHttpClientConnections().intValue());
        cm.setDefaultMaxPerRoute(MozuConfig.getDefaultHttpClientMaxPerRoute().intValue());
        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 10000L;
            }
        };
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(MozuConfig.getHttpClientTimeoutMillis().intValue()).setSocketTimeout(MozuConfig.getHttpClientTimeoutMillis().intValue()).setConnectionRequestTimeout(MozuConfig.getHttpClientTimeoutMillis().intValue()).build();
        this.threadSafeClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).useSystemProperties().disableConnectionState().setDefaultRequestConfig(requestConfig).setKeepAliveStrategy(myStrategy).build();
        this.monitor = new IdleConnectionMonitorThread(cm);
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MozuHttpClientPool getInstance() {
        if (mozuHttpClientPool != null) return mozuHttpClientPool;
        Class<MozuHttpClientPool> clazz = MozuHttpClientPool.class;
        synchronized (MozuHttpClientPool.class) {
            if (mozuHttpClientPool != null) return mozuHttpClientPool;
            mozuHttpClientPool = new MozuHttpClientPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mozuHttpClientPool;
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.threadSafeClient;
    }

    public void shutdown() {
        try {
            this.monitor.shutdown();
        }
        catch (InterruptedException ie) {
            logger.info("Intertupted shutting down HttpConnection Pooling.");
        }
    }

    private class IdleConnectionMonitorThread
    extends Thread {
        private final PoolingHttpClientConnectionManager cm;
        private final BlockingQueue<Stop> stopSignal = new ArrayBlockingQueue<Stop>(1);

        IdleConnectionMonitorThread(PoolingHttpClientConnectionManager cm) {
            this.cm = cm;
        }

        @Override
        public void run() {
            try {
                Stop stopRequest;
                while ((stopRequest = this.stopSignal.poll(5L, TimeUnit.SECONDS)) == null) {
                    this.cm.closeExpiredConnections();
                    this.cm.closeIdleConnections(60L, TimeUnit.SECONDS);
                    logger.debug("Stats: {}", (Object)this.cm.getTotalStats());
                }
                stopRequest.stopped();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() throws InterruptedException {
            logger.trace("Shutting down client pool");
            Stop stop = new Stop();
            this.stopSignal.add(stop);
            stop.waitForStopped();
            try {
                MozuHttpClientPool.this.threadSafeClient.close();
            }
            catch (IOException ioe) {
                logger.info("IO Exception while closing HttpClient connecntions.");
            }
            this.cm.close();
            logger.trace("Client pool shut down");
        }

        private class Stop {
            private final BlockingQueue<Stop> stop = new ArrayBlockingQueue<Stop>(1);

            private Stop() {
            }

            public void stopped() {
                this.stop.add(this);
            }

            public void waitForStopped() throws InterruptedException {
                this.stop.poll(30L, TimeUnit.SECONDS);
            }
        }
    }
}

