/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk.model.registration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class Account {
    @JsonProperty(value="account_id", required=true)
    private int accountId;
    @JsonProperty(value="account_settings")
    private Map<String, String> accountSettings;

    public int getAccountId() {
        return this.accountId;
    }

    public Account setAccountId(int accountId) {
        this.accountId = accountId;
        return this;
    }

    public Map<String, String> getAccountSettings() {
        return this.accountSettings;
    }

    public Account setAccountSettings(Map<String, String> accountSettings) {
        this.accountSettings = accountSettings;
        return this;
    }

    public String getStringSetting(String name, Boolean required, String defaultValue) throws IllegalArgumentException {
        String stringValue = this.accountSettings.get(name);
        if (stringValue == null) {
            if (required.booleanValue()) {
                throw new IllegalArgumentException("The required setting '" + name + "' is not provided.");
            }
            return defaultValue;
        }
        return stringValue;
    }

    public Integer getIntegerSetting(String name, Boolean required, Integer defaultValue) throws IllegalArgumentException {
        String stringValue = this.accountSettings.get(name);
        if (stringValue == null) {
            if (required.booleanValue()) {
                throw new IllegalArgumentException("The required setting '" + name + "' is not provided.");
            }
            return defaultValue;
        }
        return Integer.parseInt(stringValue);
    }

    public Double getFloatSetting(String name, Boolean required, Double defaultValue) throws IllegalArgumentException {
        String stringValue = this.accountSettings.get(name);
        if (stringValue == null) {
            if (required.booleanValue()) {
                throw new IllegalArgumentException("The required setting '" + name + "' is not provided.");
            }
            return defaultValue;
        }
        return Double.parseDouble(stringValue);
    }

    public Boolean getBooleanSetting(String name, Boolean required, Boolean defaultValue) throws IllegalArgumentException {
        String stringValue = this.accountSettings.get(name);
        if (stringValue == null) {
            if (required.booleanValue()) {
                throw new IllegalArgumentException("The required setting '" + name + "' is not provided.");
            }
            return defaultValue;
        }
        return Boolean.parseBoolean(stringValue);
    }
}

