/*
 * Decompiled with CFR 0.152.
 */
package com.mysimpatico.sqlwrapper;

import com.mysimpatico.sqlwrapper.ReferencedColumn;
import com.mysimpatico.sqlwrapper.SqlWrapper;
import com.mysimpatico.sqlwrapper.Table;
import java.lang.constant.Constable;

public class Column {
    private final String name;
    private final SqlWrapper.Type type;
    protected final int typeLength;
    private final Object def;
    private final Table refTable;
    final ReferencedColumn refField;
    private final boolean unique;
    private final boolean notNull;
    private final String condition;

    public String getName() {
        return this.name;
    }

    public String getName(Table table) {
        return table == null ? this.getName() : table.getName() + "." + this.name;
    }

    public SqlWrapper.Type getType() {
        return this.type;
    }

    Object getDef() {
        return this.def;
    }

    protected Table getRefTable() {
        return this.refTable;
    }

    protected ReferencedColumn getRefField() {
        return this.refField;
    }

    public Column(boolean unique, String name, SqlWrapper.Type type) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = unique;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name) {
        this.name = name;
        this.type = SqlWrapper.Type.INT;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, SqlWrapper.Type type, boolean def) {
        this.name = name;
        this.type = type;
        this.def = type.equals((Object)SqlWrapper.Type.SMALLINT) ? (Constable)Integer.valueOf(def ? 1 : 0) : (Constable)Boolean.valueOf(def);
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, SqlWrapper.Type type, boolean def, boolean notNull) {
        this.name = name;
        this.type = type;
        this.def = type.equals((Object)SqlWrapper.Type.SMALLINT) ? (Constable)Integer.valueOf(def ? 1 : 0) : (Constable)Boolean.valueOf(def);
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, int length, SqlWrapper.Type type, Object def) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, int length, SqlWrapper.Type type, Object def, boolean notNull) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, Table refTable, ReferencedColumn refField, boolean notNull, Column checkVal) {
        this.name = name;
        this.type = refField.getType();
        this.refTable = refTable;
        this.refField = refField;
        this.def = refField.getDef();
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = name + '=' + checkVal;
    }

    public Column(String name, Table refTable, ReferencedColumn refField, boolean notNull, Column checkVal, char operator, int val) {
        this.name = name;
        this.type = refField.getType();
        this.refTable = refTable;
        this.refField = refField;
        this.def = refField.getDef();
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = name + '=' + checkVal + operator + val;
    }

    public Column(String name, int length, SqlWrapper.Type type, Object def, boolean notNull, String[] colNames, SqlWrapper.Type[] colTypes, String[] values, char[] operators, SqlWrapper.Condition[] conditions) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = notNull;
        this.condition = SqlWrapper.joinWhereClauses(null, colNames, colTypes, values, operators, conditions);
    }

    public Column(String name, int length, SqlWrapper.Type type, Object def, String[] values) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = true;
        String[] colNames = new String[values.length];
        SqlWrapper.Type[] colTypes = new SqlWrapper.Type[values.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = name;
        }
        this.condition = SqlWrapper.joinWhereClauses(colNames, colTypes, values, false);
    }

    public Column(String name, int length, SqlWrapper.Type type, boolean notNull, String[] values) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = notNull;
        String[] colNames = new String[values.length];
        SqlWrapper.Type[] colTypes = new SqlWrapper.Type[values.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = name;
            colTypes[i] = type;
        }
        this.condition = SqlWrapper.joinWhereClauses(colNames, colTypes, values, false);
    }

    public Column(String name, int length, SqlWrapper.Type type, String[] values) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = false;
        String[] colNames = new String[values.length];
        SqlWrapper.Type[] colTypes = new SqlWrapper.Type[values.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = name;
            colTypes[i] = type;
        }
        this.condition = SqlWrapper.joinWhereClauses(colNames, colTypes, values, false);
    }

    public Column(String name, int length, SqlWrapper.Type type, char[] values) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = false;
        String[] colNames = new String[values.length];
        SqlWrapper.Type[] colTypes = new SqlWrapper.Type[values.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = name;
            colTypes[i] = type;
        }
        this.condition = SqlWrapper.joinWhereClauses(colNames, colTypes, values, false);
    }

    public Column(String name, int length, SqlWrapper.Type type, int[] vals) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = false;
        String[] colNames = new String[vals.length];
        SqlWrapper.Type[] colTypes = new SqlWrapper.Type[vals.length];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = name;
            colTypes[i] = type;
        }
        this.condition = SqlWrapper.joinWhereClauses(colNames, colTypes, vals, false);
    }

    public Column(String name, SqlWrapper.Type type, Object def, boolean notNull, char operator, int val) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = name + operator + val;
    }

    public Column(String name, SqlWrapper.Type type, boolean notNull, char operator, int val) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = name + operator + val;
    }

    public Column(String name, SqlWrapper.Type type, Object def) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, Table refTable, ReferencedColumn refField) {
        this.name = name;
        this.type = refField.getType();
        this.refTable = refTable;
        this.refField = refField;
        this.def = refField.getDef();
        this.unique = false;
        this.typeLength = refField.typeLength;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, Table refTable) {
        this(name, refTable, refTable.getIdColumn());
    }

    public Column(String name, Table refTable, boolean notNull) {
        this.name = name;
        this.type = refTable.getIdColumn().getType();
        this.refTable = refTable;
        this.refField = refTable.getIdColumn();
        this.def = this.refField.getDef();
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, Table refTable, ReferencedColumn refField, boolean notNull) {
        this.name = name;
        this.type = refField.getType();
        this.refTable = refTable;
        this.refField = refField;
        this.def = refField.getDef();
        this.unique = false;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, boolean unique, Table refTable, ReferencedColumn refField, boolean notNull) {
        this.name = name;
        this.type = refField.getType();
        this.refTable = refTable;
        this.refField = refField;
        this.def = refField.getDef();
        this.unique = unique;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, SqlWrapper.Type type, Object def, Table refTable, ReferencedColumn refField) {
        this.name = name;
        this.type = type;
        this.refTable = refTable;
        this.refField = refField;
        this.def = def;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(String name, SqlWrapper.Type type) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.condition = null;
    }

    public Column(boolean unique, String name, SqlWrapper.Type type, boolean notNull) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = unique;
        this.typeLength = 0;
        this.notNull = notNull;
        this.condition = null;
    }

    public Column(String name, SqlWrapper.Type type, String checkQuery, Boolean exists) {
        this.name = name;
        this.type = type;
        this.condition = exists != null ? (exists != false ? "NOT" : "") + " EXISTS( " : "" + checkQuery + ")";
        this.unique = false;
        this.typeLength = 0;
        this.notNull = false;
        this.refTable = null;
        this.refField = null;
        this.def = null;
    }

    public Column(String name, SqlWrapper.Type type, int length) {
        this.name = name;
        this.type = type;
        this.def = null;
        this.refTable = null;
        this.refField = null;
        this.unique = false;
        this.typeLength = length;
        this.notNull = false;
        this.condition = null;
    }

    private String getDefString() {
        if (this.def == null) {
            return "";
        }
        if (this.type == SqlWrapper.TEXT || this.type == SqlWrapper.CHAR || this.type == SqlWrapper.VARCHAR) {
            return " DEFAULT \"" + this.def.toString() + "\"";
        }
        return " DEFAULT " + this.def.toString();
    }

    private String getLength() {
        if (this.typeLength != 0) {
            return "(" + this.typeLength + ")";
        }
        return "";
    }

    private String getNotNull() {
        if (this.notNull) {
            return " NOT NULL";
        }
        return "";
    }

    private String getUnique() {
        if (this.unique) {
            return " UNIQUE";
        }
        return "";
    }

    private String getReference() {
        if (this.refField != null) {
            return " REFERENCES " + this.refTable.getName() + "(" + this.refField.getName() + ")";
        }
        return "";
    }

    private String getCondition() {
        if (this.condition != null) {
            return " CHECK(" + this.condition + ")";
        }
        return "";
    }

    public String toString() {
        return this.name + " " + (Object)((Object)this.type) + this.getLength() + this.getDefString() + this.getUnique() + this.getNotNull() + this.getReference() + this.getCondition();
    }
}

