/*
 * Decompiled with CFR 0.152.
 */
package com.mysimpatico.sqlwrapper;

import com.mysimpatico.sqlwrapper.Column;
import com.mysimpatico.sqlwrapper.ReferencedColumn;
import com.mysimpatico.sqlwrapper.SelectableFrom;
import com.mysimpatico.sqlwrapper.Table;
import com.mysimpatico.sqlwrapper.View;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlWrapper {
    private static final String TRUE = Boolean.toString(true);
    private static final String FALSE = Boolean.toString(false);
    public static final Type TEXT = Type.TEXT;
    public static final Type INT = Type.INT;
    public static final Type BOOL = Type.BOOLEAN;
    public static final Type DATE = Type.DATE;
    public static final Type CHAR = Type.CHAR;
    public static final Type FLOAT = Type.FLOAT;
    public static final Type REAL = Type.REAL;
    public static final Type DOUBLE = Type.DOUBLE;
    public static final Type NUM = Type.NUMERIC;
    public static final Type BLOB = Type.BLOB;
    public static final Type VARCHAR = Type.VARCHAR;
    public static final Sort ASC = Sort.ASC;
    public static final Sort DESC = Sort.DESC;
    public static final String TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final int index = 1;
    public static ReferencedColumn ROWID = new ReferencedColumn("ROWID");
    private static final LinkedList<String> history = new LinkedList();
    private static Column all = new Column("*");
    static vendor db = vendor.JAVADB;
    private static final String FULL_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static long millisTestOffset = 0L;

    public static void setVendor(vendor newVendor) {
        db = newVendor;
    }

    private SqlWrapper() {
    }

    public static Connection connectToSQLite() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        Connection con = DriverManager.getConnection("jdbc:sqlite:db.sqlwrapper");
        return con;
    }

    public static Connection connectToSQLite(String path) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        Connection con = DriverManager.getConnection("jdbc:sqlite:" + path + File.separator + "db.sqlwrapper");
        return con;
    }

    public static Connection connectToSQLite(boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        Connection con = DriverManager.getConnection("jdbc:sqlite:db.sqlwrapper;create=" + create);
        return con;
    }

    public static Connection connectToSQLite(String path, boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        Connection con = DriverManager.getConnection("jdbc:sqlite: " + path + File.separator + "db.sqlwrapper;create=" + create);
        return con;
    }

    public static boolean shutDownDerby() {
        try {
            Connection con = SqlWrapper.connectToDerby();
            con.close();
            con = DriverManager.getConnection("jdbc:derby:db.sqlwrapper;shutdown=true");
        }
        catch (SQLException e) {
            return true;
        }
        return false;
    }

    public static Connection connectToDerby() throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:db.sqlwrapper;create=false");
        return con;
    }

    public static Connection connectToInMemoryDerby() throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:memory:db.sqlwrapper;create=false");
        return con;
    }

    public static Connection connectToInMemoryDerby(boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:memory:db.sqlwrapper;create=" + create);
        return con;
    }

    public static Connection connectToDerby(boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:db.sqlwrapper;create=" + create);
        return con;
    }

    public static final Connection connectToDerby(String parentPath) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:" + parentPath + File.separator + "db.sqlwrapper;create=" + false);
        return con;
    }

    public static final Connection connectToDerby(File parentFolder) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:" + parentFolder.getAbsolutePath() + File.separator + "db.sqlwrapper;create=" + false);
        return con;
    }

    public static final Connection connectToDerby(String parentPath, boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:" + parentPath + File.separator + "db.sqlwrapper;create=" + create);
        return con;
    }

    public static final Connection connectToDerby(File parentPath, boolean create) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection con = DriverManager.getConnection("jdbc:derby:" + parentPath.getAbsolutePath() + File.separator + "db.sqlwrapper;create=" + create);
        return con;
    }

    public static Connection getConnection(boolean autoCommit, File parentFile) throws Exception {
        Connection con = null;
        try {
            con = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (Exception e) {
            con = SqlWrapper.connectToDerby(parentFile);
            con.setAutoCommit(autoCommit);
        }
        return con;
    }

    public static String escapeString(String s) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(s);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("\\\\");
            } else if (character == '\'') {
                result.append("''");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private static final String joinStrings(String[] strings, Condition[] conditions) {
        String joinedStrings = strings[0];
        for (int i = 1; i < strings.length; ++i) {
            joinedStrings = joinedStrings.concat(conditions == null ? "," + strings[i] : " " + (Object)((Object)conditions[i - 1]) + " " + strings[i]);
        }
        return joinedStrings;
    }

    private static final String joinTables(SelectableFrom[] tables) {
        String[] strings = new String[tables.length];
        if (tables.length == 1 || tables[0].equals(tables[1])) {
            return tables[0].getName();
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = tables[i].getName();
        }
        return SqlWrapper.joinStrings(strings, null);
    }

    private static String joinColumnsTogether(SelectableFrom[] tables, Column[] columns) {
        return SqlWrapper.joinColumnsTogether(tables, columns, true);
    }

    private static String joinColumnsTogether(SelectableFrom[] tables, Column[] columns, boolean qualifiedColumnName) {
        if (qualifiedColumnName) {
            return SqlWrapper.joinStrings(SqlWrapper.joinColumns(tables, columns), null);
        }
        String[] strings = new String[columns.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = columns[i].getName();
        }
        return SqlWrapper.joinStrings(strings, null);
    }

    private static String[] joinColumns(SelectableFrom[] tables, Column[] columns) {
        String[] strings = new String[columns.length];
        int j = 0;
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = SqlWrapper.joinColumn(tables[j], columns[i]);
            if (tables.length <= j + 1) continue;
            ++j;
        }
        return strings;
    }

    private static String joinColumn(SelectableFrom table, Column column) {
        return table.getName() + "." + column.getName();
    }

    static String joinColumns(Column[] columns, QueryType qt) {
        Condition[] conds = null;
        String[] strings = new String[columns.length];
        switch (qt) {
            case CREATE: {
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = columns[i].getName().equals("RID") ? columns[i].getName() + (db.equals((Object)vendor.SQLITE) ? " INTEGER PRIMARY KEY AUTOINCREMENT" : " INT NOT NULL GENERATED ALWAYS AS IDENTITY") : columns[i].toString();
                }
                break;
            }
            case PRIMARY: {
                conds = new Condition[columns.length - 1];
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = columns[i].getName() + " IS NOT NULL ";
                    if (i >= strings.length - 1) continue;
                    conds[i] = Condition.AND;
                }
                break;
            }
            default: {
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = columns[i].getName();
                }
            }
        }
        return SqlWrapper.joinStrings(strings, conds);
    }

    private static String joinValues(String[] values) {
        String[] stringVals = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] == null || values[i].equals(TIMESTAMP) || values[i].equals(TRUE) || values[i].equals(FALSE))) {
                try {
                    Double.parseDouble(values[i]);
                }
                catch (NumberFormatException e) {
                    if (values[i].contains("'")) {
                        stringVals[i] = db != vendor.JAVADB ? "\"" + values[i] + "\"" : "'" + SqlWrapper.escapeString(values[i]) + "'";
                        continue;
                    }
                    stringVals[i] = "'" + values[i] + "'";
                    continue;
                }
            }
            stringVals[i] = values[i];
        }
        return SqlWrapper.joinStrings(stringVals, null);
    }

    static String joinClauses(boolean update, SelectableFrom[] tables, String[] colNames, Type[] colTypes, String[] values, char[] operators, Condition[] conditions) {
        values = SqlWrapper.fixForBool(tables, values);
        if (update) {
            tables = null;
        }
        String[] whereStrings = new String[values.length];
        block4: for (int i = 0; i < values.length; ++i) {
            String table = tables == null ? "" : tables[i].getName() + ".";
            if (values[i] != null && values[i].equals(TIMESTAMP)) {
                whereStrings[i] = (table != null ? table : "") + (colNames != null ? colNames[i] : "") + (operators != null ? Character.valueOf(operators[i]) : "") + values[i];
                continue;
            }
            switch (colTypes[i]) {
                case DATETIME: 
                case DATE: {
                    whereStrings[i] = values[i] == null ? (update ? table + colNames[i] + operators[i] + values[i] : table + colNames[i] + " IS NULL") : table + colNames[i] + operators[i] + "DATE('" + SqlWrapper.escapeString(values[i]) + "')";
                    continue block4;
                }
                case TEXT: 
                case CHAR: 
                case VARCHAR: {
                    whereStrings[i] = table + colNames[i];
                    if (!update && values[i] == null) {
                        int n = i;
                        whereStrings[n] = whereStrings[n] + " IS NULL";
                        continue block4;
                    }
                    int n = i;
                    whereStrings[n] = whereStrings[n] + operators[i];
                    if (values[i] == null) {
                        int n2 = i;
                        whereStrings[n2] = whereStrings[n2] + values[i];
                        continue block4;
                    }
                    int n3 = i;
                    whereStrings[n3] = whereStrings[n3] + (db != vendor.JAVADB ? "\"" + values[i] + "\"" : "'" + SqlWrapper.escapeString(values[i]) + "'");
                    continue block4;
                }
                default: {
                    whereStrings[i] = values[i] == null ? table + colNames[i] + " IS NULL" : table + colNames[i] + operators[i] + values[i];
                }
            }
        }
        return SqlWrapper.joinStrings(whereStrings, conditions);
    }

    static String joinWhereClauses(SelectableFrom[] tables, String[] colNames, Type[] colTypes, String[] values, char[] operators, Condition[] conditions) {
        return SqlWrapper.joinClauses(false, tables, colNames, colTypes, values, operators, conditions);
    }

    private static String joinWhereClauses(SelectableFrom[] tables, Column[] columns, String[] values, char[] operators, Condition[] conditions) {
        return SqlWrapper.joinClauses(false, tables, columns, values, operators, conditions);
    }

    private static String joinClauses(boolean update, SelectableFrom[] tables, Column[] columns, String[] values, char[] operators, Condition[] conditions) {
        if (columns.length != values.length) {
            throw new RuntimeException();
        }
        String[] colNames = new String[columns.length];
        Type[] colTypes = new Type[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            colNames[i] = columns[i].getName();
            colTypes[i] = columns[i].getType();
        }
        return SqlWrapper.joinClauses(update, tables, colNames, colTypes, values, operators, conditions);
    }

    static String joinWhereClauses(String[] colNames, Type[] colTypes, String[] values, boolean AND) {
        char[] operators = new char[values.length];
        Condition[] conditions = new Condition[values.length];
        for (int i = 0; i < values.length; ++i) {
            operators[i] = 61;
            conditions[i] = AND ? Condition.AND : Condition.OR;
        }
        return SqlWrapper.joinWhereClauses(null, colNames, colTypes, values, operators, conditions);
    }

    static String joinWhereClauses(String[] colNames, Type[] colTypes, char[] values, boolean AND) {
        String[] sValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            sValues[i] = Character.toString(values[i]);
        }
        return SqlWrapper.joinWhereClauses(colNames, colTypes, sValues, AND);
    }

    static String joinWhereClauses(String[] colNames, Type[] colTypes, int[] vals, boolean AND) {
        char[] operators = new char[vals.length];
        Condition[] conditions = new Condition[vals.length];
        String[] values = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            operators[i] = 61;
            conditions[i] = AND ? Condition.AND : Condition.OR;
            values[i] = Integer.toString(vals[i]);
        }
        return SqlWrapper.joinWhereClauses(null, colNames, colTypes, values, operators, conditions);
    }

    private static String joinUpdateClauses(Table table, Column[] columns, String[] values) {
        char[] operators = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            operators[i] = 61;
        }
        SelectableFrom[] tables = new Table[]{table};
        return SqlWrapper.joinClauses(true, tables, columns, values, operators, null);
    }

    private static String onConflict(ConflictResolution res, boolean update) {
        if (res == null || db == vendor.JAVADB) {
            return "";
        }
        return update ? "OR " + (Object)((Object)res) : "ON CONFLICT " + (Object)((Object)res);
    }

    private static String order(String premise, Column orderBy, Sort order) {
        return premise + " ORDER BY " + orderBy.getName() + " " + (Object)((Object)order);
    }

    private static String limit(String premise, int no) {
        return premise + " LIMIT " + no;
    }

    public static String create(Table table) {
        if (table == null) {
            throw new NullPointerException();
        }
        String ret = "CREATE TABLE " + table;
        history.add(ret);
        return ret;
    }

    public static String create(View view) {
        if (view == null) {
            throw new NullPointerException();
        }
        String ret = "CREATE VIEW " + view;
        history.add(ret);
        return ret;
    }

    private static String insertSyntax(ConflictResolution res, Table table, String suffix) {
        return "INSERT " + SqlWrapper.onConflict(res, true) + " INTO " + table.getName() + suffix;
    }

    private static String[] fixForBool(SelectableFrom[] tables, String[] values) {
        if (tables != null) {
            for (SelectableFrom t : tables) {
                if (!t.supportBoolean()) continue;
                return values;
            }
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            if (values[i].equals(FALSE)) {
                values[i] = "0";
                continue;
            }
            if (!values[i].equals(TRUE)) continue;
            values[i] = "1";
        }
        return values;
    }

    private static String[] fixForBool(Table table, String[] values) {
        SelectableFrom[] tables = new Table[]{table};
        return SqlWrapper.fixForBool(tables, values);
    }

    public static String insert(ConflictResolution res, Table table, Column[] columns, String[] values) {
        values = SqlWrapper.fixForBool(table, values);
        if (columns == null) {
            if (values == null) {
                return SqlWrapper.insert(table);
            }
            Column[] tableCols = columns = table.getColumns();
            int j = 0;
            if (values.length != columns.length) {
                columns = new Column[values.length];
                for (int i = 0; i < tableCols.length && j < columns.length; ++i) {
                    if (tableCols[i].getDef() != null) continue;
                    columns[j++] = tableCols[i];
                }
            }
        }
        String ret = SqlWrapper.insertSyntax(res, table, "(" + SqlWrapper.joinColumns(columns, QueryType.INSERT) + ") VALUES(" + SqlWrapper.joinValues(values) + ")");
        history.add(ret);
        return ret;
    }

    public static String insert(Table table, Column[] columns, String[] values) {
        return SqlWrapper.insert(null, table, columns, values);
    }

    public static String insert(ConflictResolution res, Table table) {
        String ret = SqlWrapper.insertSyntax(res, table, " DEFAULT VALUES");
        history.add(ret);
        return ret;
    }

    public static String insert(Table table) {
        Column[] cols = table.getColumns();
        String[] defs = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            defs[i] = (String)cols[i].getDef();
        }
        String ret = SqlWrapper.insertSyntax(null, table, db != vendor.JAVADB ? " DEFAULT VALUES" : "(" + SqlWrapper.joinColumns(table.getColumns(), QueryType.INSERT) + ") VALUES(" + SqlWrapper.joinValues(defs) + ")");
        history.add(ret);
        return ret;
    }

    public static String insert(Table table, String value) {
        String[] values = new String[]{value};
        return SqlWrapper.insert(table, null, values);
    }

    public static String insert(ConflictResolution res, Table table, String value) {
        String[] values = new String[]{value};
        return SqlWrapper.insert(res, table, null, values);
    }

    public static String insert(Table table, int value) {
        return SqlWrapper.insert(table, Integer.toString(value));
    }

    public static String insert(ConflictResolution res, Table table, int value) {
        return SqlWrapper.insert(res, table, Integer.toString(value));
    }

    public static String insert(ConflictResolution res, Table table, Column[] columns, double[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Double.toString(values[i]);
        }
        return SqlWrapper.insert(res, table, columns, stringValues);
    }

    public static String insert(Table table, Column[] columns, double[] values) {
        return SqlWrapper.insert(null, table, columns, values);
    }

    public static String insert(Table table, Column column, String value) {
        Column[] columns = new Column[]{column};
        String[] values = new String[]{value};
        return SqlWrapper.insert(table, columns, values);
    }

    public static String insert(Table table, Column column, Date value) {
        return SqlWrapper.insert(table, column, value.toString());
    }

    public static String insert(Table table, Column column, int value) {
        return SqlWrapper.insert(table, column, Integer.toString(value));
    }

    public static String insert(Table table, Column column, boolean value) {
        return SqlWrapper.insert(table, column, value ? 1 : 0);
    }

    public static String insert(Table table, Column[] columns, Timestamp[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = values[i].toString();
        }
        return SqlWrapper.insert(table, columns, strings);
    }

    public static String insert(Table table, Column column) {
        return SqlWrapper.insert(table, column, column.getDef().toString());
    }

    public static String insert(Table table, Column[] columns) {
        String[] defs = new String[columns.length];
        for (int i = 0; i < defs.length; ++i) {
            defs[i] = columns[i].getDef().toString();
        }
        return SqlWrapper.insert(table, columns, defs);
    }

    public static String insert(Table table, Column[] columns, String value) {
        String[] values = new String[]{value};
        return SqlWrapper.insert(table, columns, values);
    }

    public static String insert(Table table, Column[] columns, int value) {
        return SqlWrapper.insert(table, columns, Integer.toString(value));
    }

    public static String insert(ConflictResolution res, Table table, String[] values) {
        return SqlWrapper.insert(res, table, null, values);
    }

    public static String insertAll(ConflictResolution res, Table table, String[] tuples) {
        if (tuples == null) {
            return null;
        }
        String ret = "";
        for (String t : tuples) {
            ret = ret + SqlWrapper.insert(res, table, t) + ";\n";
        }
        if (ret.equals("")) {
            return null;
        }
        return ret;
    }

    public static String insert(ConflictResolution res, Table table, List<String> values) {
        return SqlWrapper.insert(res, table, values.toArray(new String[0]));
    }

    public static String insert(Table table, String[] values) {
        return SqlWrapper.insert(null, table, null, values);
    }

    public static String insert(ConflictResolution res, Table table, int[] vals) {
        return SqlWrapper.insert(res, table, null, vals);
    }

    public static String insert(ConflictResolution res, Table table, Integer[] vals) {
        String[] stringVals = new String[vals.length];
        for (int i = 0; i < stringVals.length; ++i) {
            stringVals[i] = vals[i] != null ? vals[i].toString() : null;
        }
        return SqlWrapper.insert(res, table, null, stringVals);
    }

    public static String insert(Table table, double[] values) {
        return SqlWrapper.insert(table, null, values);
    }

    public static String insert(Table table, int[] values) {
        return SqlWrapper.insert(table, null, values);
    }

    public static String insert(ConflictResolution res, Table table, Column[] columns, int[] values) {
        double[] dValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dValues[i] = values[i];
        }
        return SqlWrapper.insert(res, table, columns, dValues);
    }

    public static String insert(Table table, Column[] columns, int[] values) {
        double[] dValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            dValues[i] = values[i];
        }
        return SqlWrapper.insert(table, columns, dValues);
    }

    private static String where(String premise, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues, char[] operators, Condition[] conditions) {
        SelectableFrom[] tables2 = tables;
        if (tables.length == 1 && whereColumns.length > 1) {
            tables2 = new SelectableFrom[whereColumns.length];
            for (int i = 0; i < whereColumns.length; ++i) {
                tables2[i] = tables[0];
            }
        }
        return premise + " WHERE " + SqlWrapper.joinWhereClauses(tables2, whereColumns, whereValues, operators, conditions);
    }

    private static String where(String premise, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues, Condition[] conditions) {
        char[] operators = new char[whereColumns.length];
        for (int i = 0; i < whereColumns.length; ++i) {
            operators[i] = 61;
        }
        return SqlWrapper.where(premise, tables, whereColumns, whereValues, operators, conditions);
    }

    private static String where(String premise, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues, char[] operators) {
        Condition[] conditions = new Condition[whereColumns.length - 1];
        for (int i = 0; i < whereColumns.length - 1; ++i) {
            conditions[i] = Condition.AND;
        }
        return SqlWrapper.where(premise, tables, whereColumns, whereValues, operators, conditions);
    }

    private static String where(String premise, SelectableFrom table, Column whereColumn, String whereValue, char operator) {
        Condition[] conditions = new Condition[]{Condition.AND};
        Column[] whereColumns = new Column[]{whereColumn};
        String[] whereValues = new String[]{whereValue};
        char[] operators = new char[]{operator};
        SelectableFrom[] tables = new SelectableFrom[]{table};
        return SqlWrapper.where(premise, tables, whereColumns, whereValues, operators, conditions);
    }

    private static String where(String premise, SelectableFrom table, Column whereColumn, char operator, String whereValue) {
        return SqlWrapper.where(premise, table, whereColumn, whereValue, operator);
    }

    private static String where(String premise, SelectableFrom table, Column whereColumn, char operator, double whereValue) {
        return SqlWrapper.where(premise, table, whereColumn, operator, Double.toString(whereValue));
    }

    private static String where(String premise, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues, int primaryValueIndex) {
        Condition[] conditions = new Condition[whereColumns.length];
        String[] newValues = new String[whereColumns.length];
        newValues[0] = "(" + whereValues[0];
        for (int i = 0; i < whereColumns.length - 1; ++i) {
            if (primaryValueIndex == i) {
                conditions[i] = Condition.AND;
                whereValues[i + 1] = ") (" + whereValues[i + 1];
                whereValues[whereColumns.length] = whereValues[whereColumns.length] + ") ";
                continue;
            }
            conditions[i] = Condition.OR;
        }
        return SqlWrapper.where(premise, tables, whereColumns, whereValues, conditions);
    }

    private static String where(String premise, SelectableFrom table, Column[] whereColumns, double[] whereValues, int primaryValueIndex) {
        String[] stringValues = new String[whereColumns.length];
        SelectableFrom[] tables = new Table[whereColumns.length];
        for (int i = 0; i < whereColumns.length; ++i) {
            stringValues[i] = Double.toString(whereValues[i]);
            tables[i] = table;
        }
        return SqlWrapper.where(premise, tables, whereColumns, stringValues, primaryValueIndex);
    }

    private static String where(String premise, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues) {
        char[] operators = new char[whereColumns.length];
        Condition[] conditions = new Condition[whereColumns.length - 1];
        for (int i = 0; i < whereColumns.length - 1; ++i) {
            operators[i] = 61;
            conditions[i] = Condition.AND;
        }
        operators[operators.length - 1] = 61;
        return SqlWrapper.where(premise, tables, whereColumns, whereValues, operators, conditions);
    }

    private static String whereNotNull(String premise, Column whereColumn) {
        return premise + " WHERE " + whereColumn.getName() + " IS NOT NULL";
    }

    private static String where(String premise, SelectableFrom table, Column[] whereColumns, String[] whereValues) {
        SelectableFrom[] tables = new Table[whereColumns.length];
        for (int i = 0; i < whereColumns.length; ++i) {
            tables[i] = table;
        }
        return SqlWrapper.where(premise, tables, whereColumns, whereValues);
    }

    private static String where(String premise, SelectableFrom table, Column[] whereColumns, int[] whereVals) {
        String[] whereValues = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            whereValues[i] = Integer.toString(whereVals[i]);
        }
        return SqlWrapper.where(premise, table, whereColumns, whereVals);
    }

    private static String where(String premise, SelectableFrom[] whereTables, Column[] whereColumns, SelectableFrom[] whereTables1, Column[] whereColumns1) {
        return SqlWrapper.where(premise, whereTables, whereColumns, SqlWrapper.joinColumns(whereTables1, whereColumns1));
    }

    private static String where(String premise, SelectableFrom table, Column whereColumn, String whereValue) {
        Column[] whereColumns = new Column[]{whereColumn};
        String[] whereValues = new String[]{whereValue};
        return SqlWrapper.where(premise, table, whereColumns, whereValues);
    }

    private static String select(String selectOptions, Column[] what, SelectableFrom[] tables) {
        return selectOptions.equals("") ? "SELECT " + SqlWrapper.joinColumnsTogether(tables, what) + " FROM " + SqlWrapper.joinTables(tables) : "SELECT " + selectOptions + "(" + SqlWrapper.joinColumnsTogether(null, what, false) + ") FROM " + SqlWrapper.joinTables(tables);
    }

    private static String joinSelect(String selectOptions, Column[] what, SelectableFrom[] tables) {
        return selectOptions.equals("") ? "SELECT " + SqlWrapper.joinColumns(what, QueryType.SELECT) + " FROM " + SqlWrapper.joinTables(tables) : "SELECT " + selectOptions + "(" + SqlWrapper.joinColumns(what, QueryType.SELECT) + ") FROM " + SqlWrapper.joinTables(tables);
    }

    private static String select(String selectOptions, Column[] what, SelectableFrom table) {
        SelectableFrom[] tables = new SelectableFrom[what.length];
        for (int i = 0; i < what.length; ++i) {
            tables[i] = table;
        }
        return SqlWrapper.select(selectOptions, what, tables);
    }

    private static String select(String selectOptions, Column what, SelectableFrom table) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(selectOptions, whats, table);
    }

    public static String select(Column[] what, SelectableFrom table) {
        String ret = SqlWrapper.select("", what, table);
        history.add(ret);
        return ret;
    }

    public static String select(Column what, SelectableFrom table) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(whats, table);
    }

    private static String select(String selectOptions, Column[] what, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, String[] whereValues) {
        return SqlWrapper.where(SqlWrapper.select(selectOptions, what, tables), whereTables, whereColumns, whereValues);
    }

    private static String select(String selectOptions, Column[] what, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, char[] operators, String[] whereValues) {
        return SqlWrapper.where(SqlWrapper.select(selectOptions, what, tables), whereTables, whereColumns, whereValues, operators);
    }

    private static String select(String selectOptions, Column[] what, SelectableFrom table, Column[] whereColumns, String[] whereValues) {
        SelectableFrom[] tables = new SelectableFrom[what.length];
        for (int i = 0; i < what.length; ++i) {
            tables[i] = table;
        }
        String ret = SqlWrapper.select(selectOptions, what, tables, tables, whereColumns, whereValues);
        history.add(ret);
        return ret;
    }

    private static String select(String selectOptions, Column[] whats, SelectableFrom table, Column whereColumn, String whereValue) {
        Column[] whereColumns = new Column[]{whereColumn};
        String[] whereValues = new String[]{whereValue};
        return SqlWrapper.select(selectOptions, whats, table, whereColumns, whereValues);
    }

    private static String select(String selectOptions, Column what, SelectableFrom table, Column whereColumn, String whereValue) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(selectOptions, whats, table, whereColumn, whereValue);
    }

    private static String select(String selectOptions, Column[] whats, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, SelectableFrom[] whereTables1, Column[] whereColumns1) {
        return SqlWrapper.where(SqlWrapper.select(selectOptions, whats, tables), whereTables, whereColumns, whereTables1, whereColumns1);
    }

    public static String selectIds(Table[] tables, SelectableFrom[] whereTables, Column[] whereColumns, char[] operators, String[] whereValues) {
        Column[] idCols = new Column[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            idCols[i] = tables[i].getIdColumn();
        }
        return SqlWrapper.select(idCols, (SelectableFrom[])tables, whereTables, whereColumns, whereValues);
    }

    public static String selectId(Table table, Column[] whereColumns, char[] operators, String[] whereValues) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereColumns, operators, whereValues);
    }

    public static String selectId(Table table, Column whereColumn, String whereValue) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereColumn, whereValue);
    }

    public static String selectId(Table table, Column whereColumn, Date whereDate) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereColumn, whereDate);
    }

    public static String selectId(Table table, Column[] whereCols, String[] whereValues) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereCols, whereValues);
    }

    public static String selectId(Table table, Column[] whereCols, Integer[] whereValues) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereCols, whereValues);
    }

    public static String selectId(Table table, Column[] whereCols, int[] whereVals) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereCols, whereVals);
    }

    public static String selectId(Table table) {
        return SqlWrapper.select(table.getIdColumn(), (SelectableFrom)table);
    }

    public static String selectId(Table table, String[] values) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, values);
    }

    public static String selectId(Table table, int[] vals) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, vals);
    }

    public static String selectId(Table table, String value) {
        return SqlWrapper.selectId(table, new String[]{value});
    }

    public static String selectId(Table table, Column whereColumn, int whereVal) {
        return SqlWrapper.selectId(table, whereColumn, Integer.toString(whereVal));
    }

    public static String selectId(Table table, Column[] whereColumns, char[] operators, int[] vals) {
        String[] stringVals = new String[vals.length];
        for (int i = 0; i < stringVals.length; ++i) {
            stringVals[i] = Integer.toString(vals[i]);
        }
        return SqlWrapper.selectId(table, whereColumns, operators, stringVals);
    }

    public static String selectId(Table table, Column whereColumn, boolean whereValue, Sort order) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereColumn, whereValue, order);
    }

    public static String selectId(Table table, Column whereColumn, Date whereValue, Sort order) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, whereColumn, whereValue, order);
    }

    public static String selectId(Table table, Column orderBy, Sort order) {
        return SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, orderBy, order);
    }

    public static String selectIdWhereNotNull(Table table, Column orderBy, Sort order, Column notNullColumn) {
        return SqlWrapper.whereNotNull(SqlWrapper.select((Column)table.getIdColumn(), (SelectableFrom)table, orderBy, order), notNullColumn);
    }

    public static String selectIdWhereNotNull(Table table, Column notNullColumn) {
        return SqlWrapper.whereNotNull(SqlWrapper.selectId(table), notNullColumn);
    }

    public static String select(Column[] what, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, char[] operators, String[] whereValues) {
        String ret = SqlWrapper.select("", what, tables, whereTables, whereColumns, operators, whereValues);
        history.add(ret);
        return ret;
    }

    public static String select(Column what, SelectableFrom table, String[] whereValues) {
        return SqlWrapper.select(what, table, table.getColumns(), whereValues);
    }

    public static String select(Column what, SelectableFrom table, int[] whereVals) {
        return SqlWrapper.select(what, table, table.getColumns(), whereVals);
    }

    public static String select(Column what, SelectableFrom table, Column[] whereColumns, char[] operators, String[] whereValues) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(whats, table, whereColumns, operators, whereValues);
    }

    public static String select(Column[] what, SelectableFrom table, Column[] whereColumns, char[] operators, String[] whereValues) {
        SelectableFrom[] tables = new SelectableFrom[]{table};
        return SqlWrapper.select(what, tables, tables, whereColumns, operators, whereValues);
    }

    public static String select(Column[] whats, SelectableFrom table, char[] operators, String[] whereValues) {
        return SqlWrapper.select(whats, table, whats, operators, whereValues);
    }

    public static String select(Column[] whats, SelectableFrom table, char[] operators, double[] whereVals) {
        String[] strings = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            strings[i] = Double.toString(whereVals[i]);
        }
        return SqlWrapper.select(whats, table, whats, operators, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumns, char[] operators, double[] whereVals) {
        String[] strings = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            strings[i] = Double.toString(whereVals[i]);
        }
        return SqlWrapper.select(whats, table, whats, operators, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumns, char[] operators, int[] whereVals) {
        String[] strings = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            strings[i] = Double.toString(whereVals[i]);
        }
        return SqlWrapper.select(whats, table, whereColumns, operators, strings);
    }

    public static String select(Column what, SelectableFrom table, Column[] whereColumns, char[] operators, int[] whereVals) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(whats, table, whereColumns, operators, whereVals);
    }

    public static String select(Column[] whats, SelectableFrom table, char[] operators, int[] whereVals) {
        String[] strings = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            strings[i] = Double.toString(whereVals[i]);
        }
        return SqlWrapper.select(whats, table, whats, operators, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, char[] operators, java.util.Date[] whereValues) {
        String[] strings = new String[whereValues.length];
        for (int i = 0; i < whereValues.length; ++i) {
            strings[i] = new Timestamp(whereValues[i].getTime()).toString();
        }
        return SqlWrapper.select(whats, table, whats, operators, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, char[] operators, Timestamp[] whereValues) {
        String[] strings = new String[whereValues.length];
        for (int i = 0; i < whereValues.length; ++i) {
            strings[i] = whereValues[i].toString();
        }
        return SqlWrapper.select(whats, table, whats, operators, strings);
    }

    public static String select(Column[] whats, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, SelectableFrom[] whereTables1, Column[] whereColumns1) {
        return SqlWrapper.select("", whats, tables, whereTables, whereColumns, whereTables1, whereColumns1);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, String whereValue, Sort order) {
        return SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, order);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, Date whereValue, Sort order) {
        return SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, order);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, int whereValue, Sort order) {
        return SqlWrapper.select(what, table, whereColumn, Integer.toString(whereValue), order);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, boolean whereValue, Sort order) {
        return SqlWrapper.select(what, table, whereColumn, whereValue ? 1 : 0, order);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, boolean whereValue) {
        return SqlWrapper.select(what, table, whereColumn, whereValue ? 1 : 0);
    }

    public static String select(Column[] what, SelectableFrom table, Sort order) {
        return SqlWrapper.select(what, table, what[0], order);
    }

    public static String select(Column[] what, SelectableFrom table, Column orderBy, Sort order) {
        return SqlWrapper.order(SqlWrapper.select(what, table), orderBy, order);
    }

    public static String select(Column what, SelectableFrom table, Column orderBy, Sort order) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select(whats, table, orderBy, order);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumns, String[] whereWhats, Sort order) {
        return SqlWrapper.order(SqlWrapper.select("", whats, table, whereColumns, whereWhats), whats[0], order);
    }

    public static String select(Column[] what, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumn, String[] whereValues) {
        return SqlWrapper.select("", what, tables, whereTables, whereColumn, whereValues);
    }

    public static String selectWhereId(Column[] what, Table table, int id) {
        return SqlWrapper.select(what, (SelectableFrom)table, (Column)table.getIdColumn(), id);
    }

    public static String selectWhereId(Column what, Table table, int id) {
        return SqlWrapper.selectWhereId(new Column[]{what}, table, id);
    }

    public static String select(Column[] what, SelectableFrom[] tables, SelectableFrom whereTable, Column[] whereColumn, String[] whereValues) {
        SelectableFrom[] whereTables = new SelectableFrom[whereColumn.length];
        for (int i = 0; i < whereColumn.length; ++i) {
            whereTables[i] = whereTable;
        }
        return SqlWrapper.select(what, tables, whereTables, whereColumn, whereValues);
    }

    public static String join(Column[] whats, SelectableFrom[] tables, SelectableFrom[] whereTables, Column[] whereColumns, SelectableFrom[] whereTables1, Column[] whereColumns1) {
        String ret = SqlWrapper.where(SqlWrapper.joinSelect("", whats, tables), whereTables, whereColumns, whereTables1, whereColumns1);
        history.add(ret);
        return ret;
    }

    public static String selectAll(SelectableFrom table) {
        return SqlWrapper.select(all, table);
    }

    public static String select(Column[] whats, SelectableFrom[] tables, Column[] whereColumns, String[] whereValues) {
        return SqlWrapper.select("", whats, tables, tables, whereColumns, whereValues);
    }

    public static String select(Column what, SelectableFrom table, Column[] whereColumns, String[] whereValues) {
        Column[] whats = new Column[]{what};
        return SqlWrapper.select("", whats, table, whereColumns, whereValues);
    }

    public static String select(Column what, SelectableFrom table, Column[] whereColumns, int[] whereValues) {
        String[] strings = new String[whereValues.length];
        for (int i = 0; i < whereValues.length; ++i) {
            strings[i] = Integer.toString(whereValues[i]);
        }
        return SqlWrapper.select(what, table, whereColumns, strings);
    }

    public static String select(Column what, SelectableFrom table, Column[] whereColumns, Integer[] whereValues) {
        String[] strings = new String[whereValues.length];
        for (int i = 0; i < whereValues.length; ++i) {
            if (whereValues[i] == null) continue;
            strings[i] = whereValues[i].toString();
        }
        return SqlWrapper.select(what, table, whereColumns, strings);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, String whereValue) {
        return SqlWrapper.select("", what, table, whereColumn, whereValue);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, Timestamp whereValue) {
        return SqlWrapper.select(what, table, whereColumn, whereValue == null ? null : whereValue.toString());
    }

    public static String max(Column what, SelectableFrom table) {
        return SqlWrapper.select("MAX", what, table);
    }

    public static String selectMaxId(Table table, Column whereColumn, String whereValue) {
        String ret = SqlWrapper.select("MAX", table.getIdColumn(), (SelectableFrom)table, whereColumn, whereValue);
        history.add(ret);
        return ret;
    }

    public static String selectMaxId(Table table, Column whereColumn, int whereVal) {
        return SqlWrapper.selectMaxId(table, whereColumn, Integer.toString(whereVal));
    }

    public static String selectMaxId(Table table, Column whereColumn, Date whereDate) {
        return SqlWrapper.selectMaxId(table, whereColumn, whereDate == null ? null : whereDate.toString());
    }

    public static String max(Table table) {
        return SqlWrapper.max(table.getIdColumn(), table);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, double whereValue) {
        return SqlWrapper.select(what, table, whereColumn, Double.toString(whereValue));
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, int whereValue) {
        return SqlWrapper.select(what, table, whereColumn, (double)whereValue);
    }

    public static String select(Column[] what, SelectableFrom table, Column whereColumn, char operator, int whereValue) {
        return SqlWrapper.where(SqlWrapper.select(what, table), table, whereColumn, operator, (double)whereValue);
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, char operator, int whereValue) {
        return SqlWrapper.where(SqlWrapper.select(what, table), table, whereColumn, operator, (double)whereValue);
    }

    public static String select(Column[] whats, SelectableFrom table, Column whereColumn, String whereValue) {
        return SqlWrapper.select("", whats, table, whereColumn, whereValue);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumn, String[] whereValue) {
        return SqlWrapper.select("", whats, table, whereColumn, whereValue);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumn, double[] whereValue) {
        String[] strings = new String[whereValue.length];
        for (int i = 0; i < whereValue.length; ++i) {
            strings[i] = Double.toString(whereValue[i]);
        }
        return SqlWrapper.select(whats, table, whereColumn, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, Column[] whereColumn, int[] whereValue) {
        String[] strings = new String[whereValue.length];
        for (int i = 0; i < whereValue.length; ++i) {
            strings[i] = Double.toString(whereValue[i]);
        }
        return SqlWrapper.select(whats, table, whereColumn, strings);
    }

    public static String select(Column[] whats, SelectableFrom table, Column whereColumn, double whereValue) {
        return SqlWrapper.select(whats, table, whereColumn, Double.toString(whereValue));
    }

    public static String select(Column what, SelectableFrom table, Column whereColumn, Date whereValue) {
        return SqlWrapper.select(what, table, whereColumn, whereValue == null ? null : new SimpleDateFormat(FULL_DATE_PATTERN).format(whereValue));
    }

    public static String select(Column[] whats, SelectableFrom table, Column whereColumn, int whereValue) {
        return SqlWrapper.select(whats, table, whereColumn, (double)whereValue);
    }

    private static String groupBy(String prefix, SelectableFrom[] tables, Column[] groupBy) {
        return prefix + " GROUP BY " + SqlWrapper.joinStrings(SqlWrapper.joinColumns(tables, groupBy), null);
    }

    private static String groupBy(String prefix, SelectableFrom table, Column groupBy) {
        return SqlWrapper.groupBy(prefix, new SelectableFrom[]{table}, new Column[]{groupBy});
    }

    private static String having(String prefix, String selectOption, char havingOperator, int havingVal) {
        return prefix + " HAVING " + selectOption + havingOperator + havingVal;
    }

    public static String selectAll(SelectableFrom table, Column whereColumn, String whereValue) {
        return SqlWrapper.select(all, table, whereColumn, whereValue);
    }

    private static String selectAll(String selectOption, SelectableFrom table) {
        return SqlWrapper.select(selectOption, all, table);
    }

    public static String selectAll(SelectableFrom table, Column[] whereColumn, String[] whereValues) {
        return SqlWrapper.select(all, table, whereColumn, whereValues);
    }

    public static String selectAll(SelectableFrom table, Column whereColumn, int whereValue) {
        return SqlWrapper.select(all, table, whereColumn, whereValue);
    }

    public static String last(Column what, SelectableFrom table, int no) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table), what, Sort.DESC), no);
    }

    public static String first(Column what, SelectableFrom table, int no) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table), what, Sort.ASC), no);
    }

    public static String first(Column what, SelectableFrom table) {
        return SqlWrapper.first(what, table, 1);
    }

    public static String last(Column what, SelectableFrom table) {
        String ret = "SELECT " + what.getName() + " FROM " + table.getName() + " WHERE RID >= (SELECT MAX(RID) FROM " + table.getName() + ")";
        if (db != vendor.JAVADB) {
            return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table), what, Sort.DESC), 1);
        }
        history.add(ret);
        return ret;
    }

    public static String last(Table table) {
        return SqlWrapper.last(table.getIdColumn(), table);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, String whereValue, int no) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.DESC), no);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, char operator, int whereValue) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, operator, whereValue), what, Sort.DESC), 1);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, String whereValue) {
        String ret = "SELECT " + what.getName() + " FROM " + table.getName() + " WHERE " + whereColumn.getName() + "='" + whereValue + "' AND RID >= (SELECT MAX(RID) FROM " + table.getName() + ")";
        if (db != vendor.JAVADB) {
            return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.DESC), 1);
        }
        history.add(ret);
        return ret;
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, double whereValue) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.DESC), 1);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, Timestamp whereValue) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.DESC), 1);
    }

    public static String first(Column what, SelectableFrom table, Column whereColumn, String whereValue, int no) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.ASC), no);
    }

    public static String first(Column what, SelectableFrom table, Column whereColumn, String whereValue) {
        return SqlWrapper.first(what, table, whereColumn, whereValue, 1);
    }

    public static String first(Column what, SelectableFrom table, Column whereColumn, int whereValue) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.ASC), 1);
    }

    public static String first(Column what, SelectableFrom table, Column whereColumn, double whereValue) {
        return SqlWrapper.limit(SqlWrapper.order(SqlWrapper.select(what, table, whereColumn, whereValue), what, Sort.ASC), 1);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, int whereValue, int no) {
        return SqlWrapper.last(what, table, whereColumn, Integer.toString(whereValue), no);
    }

    public static String last(Column what, SelectableFrom table, Column whereColumn, int whereValue) {
        return SqlWrapper.last(what, table, whereColumn, whereValue, 1);
    }

    public static String count(Column[] what, SelectableFrom table, Column[] whereColumn, String[] whereWhat) {
        return SqlWrapper.select("COUNT", what, table, whereColumn, whereWhat);
    }

    public static String count(SelectableFrom table) {
        return SqlWrapper.count(all, table);
    }

    public static String count(Column what, SelectableFrom table) {
        return SqlWrapper.select("COUNT", what, table);
    }

    public static String count(Column what, SelectableFrom table, Column whereColumn, String whereWhat) {
        Column[] whats = new Column[]{what};
        Column[] whereColumns = new Column[]{whereColumn};
        String[] whereWhats = new String[]{whereWhat};
        return SqlWrapper.count(whats, table, whereColumns, whereWhats);
    }

    public static String count(SelectableFrom table, Column groupBy, char havingOperator, int havingVal) {
        String ret = SqlWrapper.having(SqlWrapper.groupBy(SqlWrapper.selectAll("COUNT", table), table, groupBy), "COUNT(*)", havingOperator, havingVal);
        history.add(ret);
        return ret;
    }

    public static String count(Column what, SelectableFrom table, Column whereColumn, double whereWhat) {
        return SqlWrapper.count(what, table, whereColumn, Double.toString(whereWhat));
    }

    public static String count(Column what, SelectableFrom table, Column whereColumn, int whereWhat) {
        return SqlWrapper.count(what, table, whereColumn, (double)whereWhat);
    }

    public static String count(SelectableFrom table, Column whereColumn, int whereWhat) {
        return SqlWrapper.count(all, table, whereColumn, (double)whereWhat);
    }

    public static String update(Table table, Column column, int value, Column whereColumn, int whereWhat) {
        return SqlWrapper.update(table, column, (double)value, whereColumn, Double.toString(whereWhat));
    }

    public static String update(Table table, Column column, String value) {
        Column[] columns = new Column[]{column};
        String[] values = new String[]{value};
        return SqlWrapper.update(table, columns, values);
    }

    public static String update(Table table, Column column, int value) {
        return SqlWrapper.update(table, column, Integer.toString(value));
    }

    public static String update(Table table, Column column, boolean value, Column whereColumn, int whereWhat) {
        return SqlWrapper.update(table, column, value ? 1.0 : 0.0, whereColumn, (double)whereWhat);
    }

    public static String update(Table table, Column column, boolean value, Column whereColumn, String[] whereValues) {
        Column[] whereColumns = new Column[whereValues.length];
        for (int i = 0; i < whereValues.length; ++i) {
            whereColumns[i] = whereColumn;
        }
        return SqlWrapper.update(table, column, value, whereColumns, whereValues);
    }

    public static String update(Table table, Column column, boolean value, Column whereColumn, int[] whereVals) {
        String[] whereValues = new String[whereVals.length];
        for (int i = 0; i < whereVals.length; ++i) {
            whereValues[i] = Integer.toString(whereVals[i]);
        }
        return SqlWrapper.update(table, column, value, whereColumn, whereValues);
    }

    public static String update(Table table, Column column, boolean value, Column[] whereColumns, String[] whereValues) {
        return SqlWrapper.where(SqlWrapper.set(table, column, value ? 1 : 0), (SelectableFrom)table, whereColumns, whereValues);
    }

    public static String update(Table table, Column column, boolean value, Column[] whereColumns, int[] whereValues) {
        return SqlWrapper.where(SqlWrapper.set(table, column, value ? 1 : 0), (SelectableFrom)table, whereColumns, whereValues);
    }

    public static String update(Table table, Column column, Date value, Column whereColumn, double whereWhat) {
        return SqlWrapper.update(table, column, value.toString(), whereColumn, Double.toString(whereWhat));
    }

    public static String setNull(Table table, Column column, Column whereColumn, double whereWhat) {
        return SqlWrapper.update(table, column, null, whereColumn, Double.toString(whereWhat));
    }

    public static String setNull(Table table, Column column) {
        return SqlWrapper.update(table, column, null);
    }

    public static String setNull(Table table, Column column, Column whereColumn, String whereWhat) {
        return SqlWrapper.update(table, column, null, whereColumn, whereWhat);
    }

    public static String updateTime(Table table, Column column, Column whereColumn, double whereWhat) {
        return SqlWrapper.update(table, column, new Date(System.currentTimeMillis() + millisTestOffset).toString(), whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, String value, Column whereColumn, String whereWhat) {
        String ret = SqlWrapper.where(SqlWrapper.set(table, column, value), (SelectableFrom)table, whereColumn, whereWhat);
        history.add(ret);
        return ret;
    }

    public static String update(Table table, Column column, String newValue, String oldValue) {
        return SqlWrapper.update(table, column, newValue, column, oldValue);
    }

    public static String update(Table table, Column[] columns, String[] values) {
        return SqlWrapper.set(table, columns, values);
    }

    public static String update(Table table, Column[] columns, String[] values, Column whereColumn, String whereValue) {
        return SqlWrapper.where(SqlWrapper.set(table, columns, values), (SelectableFrom)table, whereColumn, whereValue);
    }

    public static String update(Table table, Column[] columns, int[] vals, Column whereColumn, String whereValue) {
        String[] values = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            values[i] = Integer.toString(vals[i]);
        }
        return SqlWrapper.where(SqlWrapper.set(table, columns, values), (SelectableFrom)table, whereColumn, whereValue);
    }

    public static String update(Table table, Column[] columns, int[] vals, Column whereColumn, int whereValue) {
        return SqlWrapper.update(table, columns, vals, whereColumn, Integer.toString(whereValue));
    }

    public static String update(Table table, Column[] columns, double[] values, Column whereColumn, String whereValue) {
        return SqlWrapper.where(SqlWrapper.set(table, columns, values), (SelectableFrom)table, whereColumn, whereValue);
    }

    public static String update(Table table, Column[] columns, double[] values, Column whereColumn, int whereValue) {
        return SqlWrapper.update(table, columns, values, whereColumn, Double.toString(whereValue));
    }

    public static String update(Table table, Column[] columns, double[] values, Column whereColumn, double whereValue) {
        return SqlWrapper.update(table, columns, values, whereColumn, Double.toString(whereValue));
    }

    public static String update(Table table, Column column, String value, Column whereColumn, double whereWhat) {
        return SqlWrapper.update(table, column, value, whereColumn, Double.toString(whereWhat));
    }

    public static String update(Table table, Column column, String value, Column whereColumn, int whereWhat) {
        return SqlWrapper.update(table, column, value, whereColumn, (double)whereWhat);
    }

    public static String update(Table table, Column column, boolean value, Column whereColumn, String whereWhat) {
        return SqlWrapper.update(table, column, value ? 1 : 0, whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, int value, Column whereColumn, String whereWhat) {
        return SqlWrapper.update(table, column, (double)value, whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, String value, Column whereColumn, Timestamp whereWhat) {
        return SqlWrapper.update(table, column, value, whereColumn, new SimpleDateFormat(FULL_DATE_PATTERN).format(whereWhat));
    }

    public static String update(Table table, Column column, int value, Column whereColumn, Timestamp whereWhat) {
        return SqlWrapper.update(table, column, Integer.toString(value), whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, Timestamp value, Column whereColumn, int whereWhat) {
        return SqlWrapper.update(table, column, new SimpleDateFormat(FULL_DATE_PATTERN).format(value), whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, Timestamp value, Column whereColumn, Timestamp whereWhat) {
        return SqlWrapper.update(table, column, new SimpleDateFormat(FULL_DATE_PATTERN).format(value), whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, double value, Column whereColumn, String whereWhat) {
        return SqlWrapper.update(table, column, Double.toString(value), whereColumn, whereWhat);
    }

    public static String update(Table table, Column column, double value, Column whereColumn, double whereWhat) {
        return SqlWrapper.update(table, column, value, whereColumn, Double.toString(whereWhat));
    }

    public static String update(Table table, String[] values, int primaryValueIndex) {
        SelectableFrom[] tables = new Table[values.length];
        for (int i = 0; i < values.length; ++i) {
            tables[i] = table;
        }
        return SqlWrapper.where(SqlWrapper.set(table, table.getColumns(), values), tables, table.getColumns(), values, primaryValueIndex);
    }

    public static String update(Table table, double[] values, int primaryValueIndex) {
        return SqlWrapper.where(SqlWrapper.set(table, table.getColumns(), values), (SelectableFrom)table, table.getColumns(), values, primaryValueIndex);
    }

    public static String increment(Table table, Column what, double increment, Column whereColumn, String whereWhat) {
        return SqlWrapper.update(table, what, what.getName() + "+" + Double.toString(increment), whereColumn, whereWhat);
    }

    public static String increment(Table table, Column what, int increment, Column whereColumn, String whereWhat) {
        return SqlWrapper.increment(table, what, (double)increment, whereColumn, whereWhat);
    }

    public static String increment(Table table, Column what, double increment, Column whereColumn, double whereWhat) {
        return SqlWrapper.increment(table, what, increment, whereColumn, Double.toString(whereWhat));
    }

    public static String increment(Table table, Column what, int increment, Column whereColumn, double whereWhat) {
        return SqlWrapper.increment(table, what, (double)increment, whereColumn, whereWhat);
    }

    private static String set(Table table, Column[] columns, String[] values) {
        return "UPDATE " + table.getName() + " SET " + SqlWrapper.joinUpdateClauses(table, columns, values);
    }

    private static String set(Table table, Column[] columns, double[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Double.toString(values[i]);
        }
        return SqlWrapper.set(table, columns, stringValues);
    }

    private static String set(Table table, Column column, String value) {
        Column[] columns = new Column[]{column};
        String[] values = new String[]{value};
        return SqlWrapper.set(table, columns, values);
    }

    private static String set(Table table, Column column, int value) {
        Column[] columns = new Column[]{column};
        String[] values = new String[]{Integer.toString(value)};
        return SqlWrapper.set(table, columns, values);
    }

    public static String dropTable(Table table) {
        String ret = "DROP TABLE " + table.getName();
        history.add(ret);
        return ret;
    }

    public static String deleteAll(Table table) {
        String ret = "DELETE FROM " + table.getName();
        history.add(ret);
        return ret;
    }

    public static String delete(Table table, Column whereColumn, String whereValue) {
        return SqlWrapper.deleteAll(table) + " " + SqlWrapper.where("", (SelectableFrom)table, whereColumn, whereValue);
    }

    public static String intersect(String query, String query1) {
        String ret = query + " INTERSECT " + query1;
        history.add(ret);
        return ret;
    }

    public static String trigger(String name, boolean after, Table table, QueryType qt, boolean forEachRow, String triggerStatement) {
        String ret = "CREATE TRIGGER " + name + (after ? " AFTER " : " NO CASCADE BEFORE ") + (Object)((Object)qt) + " ON " + table.getName() + " FOR EACH " + (forEachRow ? "ROW " : "STATEMENT ") + triggerStatement;
        history.add(ret);
        return ret;
    }

    public static void printHistory() {
        for (String s : history) {
            System.out.println(s + ";");
        }
    }

    public static String updateWhereId(Table table, Column what, Date value, int id) {
        return SqlWrapper.update(table, what, value, (Column)table.getIdColumn(), (double)id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum vendor {
        SQLITE,
        JAVADB;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum setOperators {
        INTERSECT,
        UNION,
        EXCEPT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConflictResolution {
        ROLLBACK,
        ABORT,
        FAIL,
        IGNORE,
        REPLACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        SELECT,
        CREATE,
        JOIN,
        TABLES,
        INSERT,
        FOREIGN,
        PRIMARY,
        UPDATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Condition {
        AND,
        OR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        ASC,
        DESC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reserved {
        group,
        GROUP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TEXT,
        INT,
        BYTE,
        TINYINT,
        SMALLINT,
        BOOLEAN,
        DATETIME,
        DATE,
        DOUBLE,
        FLOAT,
        REAL,
        CHAR,
        VARCHAR,
        BLOB,
        NUMERIC;

    }
}

