/*
 * Decompiled with CFR 0.152.
 */
package com.mysimpatico.sqlwrapper;

import com.mysimpatico.sqlwrapper.Column;
import com.mysimpatico.sqlwrapper.ReferencedColumn;
import com.mysimpatico.sqlwrapper.SelectableFrom;
import com.mysimpatico.sqlwrapper.SqlWrapper;

public class Table
implements SelectableFrom {
    private final String name;
    private final Column[] allColumns;
    private final Column[] columns;
    private final Column[] primaryKeys;
    private final boolean foreignKeys;
    private final ReferencedColumn ridColumn = new ReferencedColumn("RID");
    private final Table refTable;
    private final String condition;

    public Table(String name, Column[] columns) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = new Column[]{this.ridColumn};
        this.foreignKeys = false;
        this.refTable = null;
        this.condition = null;
    }

    public Table(String name, Column column) {
        this(name, new Column[]{column});
    }

    public Table(String name, Column column, Column primaryKey) {
        this(name, new Column[]{column}, new Column[]{primaryKey});
    }

    public Table(String name, Column[] columns, Column[] primaryKeys, boolean foreignKeys) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = primaryKeys;
        this.foreignKeys = foreignKeys;
        this.refTable = primaryKeys[0].getRefTable();
        this.condition = null;
    }

    public Table(String name, Column[] columns, Table refTable, Column[] primaryKeys) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = primaryKeys;
        this.foreignKeys = true;
        this.refTable = refTable;
        this.condition = null;
    }

    public Table(String name, Column[] columns, Table refTable, Column primaryKey) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = new Column[1];
        this.primaryKeys[0] = primaryKey;
        this.foreignKeys = true;
        this.refTable = refTable;
        this.condition = null;
    }

    public Table(String name, Column[] columns, Column[] primaryKeys) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = primaryKeys;
        this.foreignKeys = false;
        this.refTable = null;
        this.condition = null;
    }

    public Table(String name, Column[] columns, Column[] primaryKeys, String checkQuery) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.primaryKeys = primaryKeys;
        this.foreignKeys = false;
        this.refTable = null;
        this.condition = checkQuery;
    }

    public Table(String name, Column[] columns, Column primaryKey) {
        this(name, columns, new Column[]{primaryKey});
    }

    public Table(String name, Column[] columns, boolean exists, String checkQuery) {
        this.name = name;
        this.columns = columns;
        this.allColumns = new Column[columns.length + 1];
        this.allColumns[columns.length] = this.ridColumn;
        for (int i = 0; i < columns.length; ++i) {
            this.allColumns[i] = columns[i];
        }
        this.condition = (exists ? "" : "NOT") + " EXISTS( " + checkQuery + ")";
        this.refTable = null;
        this.primaryKeys = null;
        this.foreignKeys = false;
    }

    public Table(String name, Column col, boolean exists, String checkQuery) {
        this(name, new Column[]{col}, exists, checkQuery);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.allColumns.length;
    }

    public int defsize() {
        int counter = 0;
        for (Column c : this.allColumns) {
            if (c.getDef() == null) continue;
            ++counter;
        }
        return counter;
    }

    private String getForeign() {
        String string;
        if (this.foreignKeys) {
            String foreign = SqlWrapper.joinColumns(this.primaryKeys, SqlWrapper.QueryType.FOREIGN);
            string = ", FOREIGN KEY (" + foreign + ") REFERENCES " + this.refTable.getName() + " (" + foreign + ")";
        } else {
            string = "";
        }
        return string;
    }

    private String getPrimaryKey() {
        return this.primaryKeys == null ? "" : " " + (SqlWrapper.db.equals((Object)SqlWrapper.vendor.SQLITE) ? ", UNIQUE (" + SqlWrapper.joinColumns(this.primaryKeys, SqlWrapper.QueryType.FOREIGN) + ") CHECK(" + SqlWrapper.joinColumns(this.primaryKeys, SqlWrapper.QueryType.PRIMARY) + ")" : ", PRIMARY KEY(" + SqlWrapper.joinColumns(this.primaryKeys, SqlWrapper.QueryType.FOREIGN) + ")");
    }

    private String getCondition() {
        return this.condition == null ? "" : ", CHECK( " + this.condition + ")";
    }

    public final String toString() {
        return this.name + " (" + SqlWrapper.joinColumns(this.allColumns, SqlWrapper.QueryType.CREATE) + this.getPrimaryKey() + this.getForeign() + this.getCondition() + ")";
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Column[] getAllColumns() {
        return this.allColumns;
    }

    public ReferencedColumn getIdColumn() {
        return this.ridColumn;
    }

    public boolean supportBoolean() {
        for (Column c : this.allColumns) {
            if (!c.getType().equals((Object)SqlWrapper.Type.BOOLEAN)) continue;
            return true;
        }
        return false;
    }
}

