/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json;

import com.neko233.json.convert.DefaultJsonConfig;
import com.neko233.json.convert.JsonConfig;
import com.neko233.json.convert.PrettyJsonConfig;
import com.neko233.json.deserializer.JsonParser;
import com.neko233.json.exception.DeserializeJsonException;
import com.neko233.json.formatter.JsonFormatter;
import com.neko233.json.serializer.JsonSerializer;
import com.neko233.json.typeRef.GenericTypeFactory;
import com.neko233.json.typeRef.JsonTypeRef;
import com.neko233.json.utils.BeanJsonOrmUtils;
import com.neko233.json.utils.CollectionUtilsForJson;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public interface Json233 {
    public static String serialize(Object object) {
        return Json233.serialize(object, null);
    }

    public static String serializePretty(Object object) {
        return Json233.serialize(object, PrettyJsonConfig.instance);
    }

    public static String serialize(Object object, JsonConfig jsonConfig) {
        if (object == null) {
            return "";
        }
        jsonConfig = jsonConfig == null ? DefaultJsonConfig.instance : jsonConfig;
        JsonSerializer jsonSerializer = new JsonSerializer(jsonConfig);
        String serialize = jsonSerializer.serialize(object);
        if (jsonConfig.isPretty()) {
            return JsonFormatter.formatJson(serialize);
        }
        return serialize;
    }

    @Nullable
    public static byte[] serializeToBytes(Object object, JsonConfig jsonConfig) {
        return Json233.serializeToBytes(object, StandardCharsets.UTF_8, jsonConfig);
    }

    @Nullable
    public static byte[] serializeToBytes(Object object, Charset charset, JsonConfig jsonConfig) {
        return Json233.serialize(object, jsonConfig).getBytes(charset);
    }

    public static Map<String, Object> deserialize(byte[] bytes) {
        return Json233.deserialize(bytes, StandardCharsets.UTF_8);
    }

    public static Map<String, Object> deserialize(byte[] bytes, Charset charset) {
        return Json233.deserialize(new String(bytes, charset));
    }

    public static Map<String, Object> deserialize(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        List<Map<String, Object>> mapList = jsonParser.parseJson(text);
        if (CollectionUtilsForJson.isEmpty(mapList)) {
            return null;
        }
        return mapList.get(0);
    }

    public static <T> T deserialize(String text, JsonTypeRef<T> jsonTypeRef) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        List<Map<String, Object>> mapList = jsonParser.parseJson(text);
        if (CollectionUtilsForJson.isEmpty(mapList)) {
            return null;
        }
        Map<String, Object> kvMap = mapList.get(0);
        Type genericType = jsonTypeRef.getType();
        Type rawType = ((ParameterizedTypeImpl)genericType).getRawType();
        if (rawType == Map.class) {
            return (T)kvMap;
        }
        if (genericType == null) {
            return null;
        }
        if (rawType == null) {
            return null;
        }
        try {
            Object instance = GenericTypeFactory.createInstance(genericType);
            return (T)BeanJsonOrmUtils.mapToBean(kvMap, instance.getClass());
        }
        catch (Exception e) {
            throw new DeserializeJsonException(e);
        }
    }

    public static List<Map<String, Object>> deserializeArray(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parseJson(text);
    }

    @Nullable
    public static <T> List<T> deserializeArray(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        List<Map<String, Object>> maps = jsonParser.parseJson(text);
        if (clazz == Map.class) {
            return maps;
        }
        return maps.stream().map(map -> {
            try {
                return BeanJsonOrmUtils.mapToBean(map, clazz);
            }
            catch (Exception e) {
                throw new DeserializeJsonException(e, "\u53cd\u5e8f\u5217\u5316\u5931\u8d25. json Text = {}", text);
            }
        }).collect(Collectors.toList());
    }

    public static <T> T deserialize(String text, Class<T> clazz) throws Exception {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        List<Map<String, Object>> mapList = jsonParser.parseJson(text);
        if (CollectionUtilsForJson.isEmpty(mapList)) {
            return null;
        }
        Map<String, Object> map = mapList.get(0);
        if (clazz == null) {
            return (T)map;
        }
        if (map == null) {
            return null;
        }
        try {
            return BeanJsonOrmUtils.mapToBean(map, clazz);
        }
        catch (Exception e) {
            throw new DeserializeJsonException(e, "\u53cd\u5e8f\u5217\u5316\u5931\u8d25. json Text = {}", text);
        }
    }
}

