/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.deserializer;

import com.neko233.json.utils.StringUtilsForJson;
import com.neko233.json.utils.TextTokenUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private int currentIndex;
    private String jsonString;

    public List<Map<String, Object>> parseJson(String json) {
        if (StringUtilsForJson.isBlank(json)) {
            return null;
        }
        this.currentIndex = 0;
        this.jsonString = TextTokenUtils.removeCharInTargetRange(json);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (this.jsonString.startsWith("{")) {
            Map<String, Object> jsonObject = this.parseObject();
            resultList.add(jsonObject);
        } else if (this.jsonString.startsWith("[")) {
            List<Object> jsonArray = this.parseArray();
            for (Object item : jsonArray) {
                if (item instanceof Map) {
                    resultList.add((Map)item);
                    continue;
                }
                if (!(item instanceof Number) && !(item instanceof String) && !(item instanceof Boolean)) continue;
                resultList.add(Collections.singletonMap("@default", item));
            }
        }
        return resultList;
    }

    private Map<String, Object> parseObject() {
        char currentChar;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ++this.currentIndex;
        while (this.currentIndex < this.jsonString.length() && (currentChar = this.jsonString.charAt(this.currentIndex)) != '}') {
            if (currentChar == ',') {
                ++this.currentIndex;
                continue;
            }
            String key = this.parseString();
            ++this.currentIndex;
            Object value = this.parseValue();
            map.put(key, value);
        }
        ++this.currentIndex;
        return map;
    }

    private List<Object> parseArray() {
        char currentChar;
        ArrayList<Object> list = new ArrayList<Object>();
        ++this.currentIndex;
        while (this.currentIndex < this.jsonString.length() && (currentChar = this.jsonString.charAt(this.currentIndex)) != ']') {
            if (currentChar == ',') {
                ++this.currentIndex;
                continue;
            }
            Object value = this.parseValue();
            list.add(value);
        }
        ++this.currentIndex;
        return list;
    }

    private Object parseValue() {
        char currentChar = this.jsonString.charAt(this.currentIndex);
        if (currentChar == '\"') {
            return this.parseString();
        }
        if (currentChar == '{') {
            return this.parseObject();
        }
        if (currentChar == '[') {
            return this.parseArray();
        }
        return this.parsePrimitive();
    }

    private String parseString() {
        ++this.currentIndex;
        StringBuilder builder = new StringBuilder();
        while (this.currentIndex < this.jsonString.length()) {
            char currentChar = this.jsonString.charAt(this.currentIndex);
            if (currentChar == '\"') {
                ++this.currentIndex;
                break;
            }
            builder.append(currentChar);
            ++this.currentIndex;
        }
        return builder.toString();
    }

    private Object parsePrimitive() {
        char currentChar;
        StringBuilder valueBuilder = new StringBuilder();
        while (this.currentIndex < this.jsonString.length() && (currentChar = this.jsonString.charAt(this.currentIndex)) != ',' && currentChar != ']' && currentChar != '}') {
            valueBuilder.append(currentChar);
            ++this.currentIndex;
        }
        String value = valueBuilder.toString().trim();
        if (value.isEmpty()) {
            return null;
        }
        if (value.equalsIgnoreCase("null")) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.contains(".") || value.contains("e") || value.contains("E")) {
            return Double.parseDouble(value);
        }
        return Long.parseLong(value);
    }
}

