/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.formatter;

public class JsonFormatter {
    public static String formatJson(String json) {
        int indentLevel = 0;
        StringBuilder formattedJson = new StringBuilder();
        boolean inQuotes = false;
        boolean isEscaped = false;
        block8: for (char character : json.toCharArray()) {
            switch (character) {
                case '[': 
                case '{': {
                    formattedJson.append(character);
                    if (inQuotes) continue block8;
                    formattedJson.append("\n");
                    JsonFormatter.appendIndentation(formattedJson, ++indentLevel);
                    continue block8;
                }
                case ']': 
                case '}': {
                    if (!inQuotes) {
                        formattedJson.append("\n");
                        JsonFormatter.appendIndentation(formattedJson, --indentLevel);
                    }
                    formattedJson.append(character);
                    continue block8;
                }
                case ',': {
                    formattedJson.append(character);
                    if (inQuotes) continue block8;
                    formattedJson.append("\n");
                    JsonFormatter.appendIndentation(formattedJson, indentLevel);
                    continue block8;
                }
                case ':': {
                    formattedJson.append(character).append(" ");
                    continue block8;
                }
                case '\"': {
                    formattedJson.append(character);
                    isEscaped = false;
                    if (inQuotes) {
                        if (isEscaped) continue block8;
                        inQuotes = false;
                        continue block8;
                    }
                    inQuotes = true;
                    continue block8;
                }
                case '\\': {
                    formattedJson.append(character);
                    isEscaped = !isEscaped;
                    continue block8;
                }
                default: {
                    formattedJson.append(character);
                }
            }
        }
        return formattedJson.toString();
    }

    private static void appendIndentation(StringBuilder stringBuilder, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append("\t");
        }
    }
}

