/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.serializer;

import com.neko233.json.convert.JsonConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class JsonSerializer {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
    private JsonConfig jsonConfig;

    public JsonSerializer(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public String serialize(Object obj) {
        StringBuilder jsonBuilder = new StringBuilder();
        this.serialize(obj, jsonBuilder);
        return jsonBuilder.toString();
    }

    private void serialize(Object obj, StringBuilder jsonBuilder) {
        if (obj == null) {
            jsonBuilder.append("null");
            return;
        }
        if (obj instanceof String) {
            jsonBuilder.append("\"").append(this.escapeString((String)obj)).append("\"");
            return;
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            jsonBuilder.append(obj.toString());
            return;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = simpleDateFormat.format(date);
            jsonBuilder.append("\"").append(this.escapeString(dateStr)).append("\"");
            return;
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)obj;
            String format = dateTime.format(DATE_TIME_FORMATTER);
            jsonBuilder.append("\"").append(this.escapeString(format)).append("\"");
            return;
        }
        if (obj instanceof LocalDate) {
            LocalDate dateTime = (LocalDate)obj;
            String format = dateTime.format(DATE_FORMATTER);
            jsonBuilder.append("\"").append(this.escapeString(format)).append("\"");
            return;
        }
        if (obj instanceof Collection) {
            this.serializeCollection((Collection)obj, jsonBuilder);
            return;
        }
        if (obj instanceof Map) {
            this.serializeMap((Map)obj, jsonBuilder);
            return;
        }
        this.serializeObject(obj, jsonBuilder);
    }

    private void serializeEnum(Enum<?> obj, StringBuilder jsonBuilder) {
        jsonBuilder.append("{");
        String escapeKey = this.escapeString(obj.name());
        jsonBuilder.append("\"").append(escapeKey).append("\":").append(obj.ordinal());
        jsonBuilder.append("}");
    }

    private void serializeCollection(Collection<?> collection, StringBuilder jsonBuilder) {
        jsonBuilder.append("[");
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            this.serialize(item, jsonBuilder);
        }
        jsonBuilder.append("]");
    }

    private void serializeMap(Map<?, ?> map, StringBuilder jsonBuilder) {
        jsonBuilder.append("{");
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            jsonBuilder.append("\"").append(this.escapeString(entry.getKey().toString())).append("\":");
            this.serialize(entry.getValue(), jsonBuilder);
        }
        jsonBuilder.append("}");
    }

    private void serializeObject(Object obj, StringBuilder jsonBuilder) {
        jsonBuilder.append("{");
        boolean first = true;
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object value;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value instanceof Enum) {
                value = ((Enum)value).ordinal();
            }
            if (value == obj) continue;
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            String jsonKey = this.escapeString(field.getName());
            jsonBuilder.append("\"").append(jsonKey).append("\":");
            this.serialize(value, jsonBuilder);
        }
        jsonBuilder.append("}");
    }

    private String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

