/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.utils;

public class EnumUtilsForJson {
    public static <T extends Enum<T>> T getEnumByOrdinal(Class<?> enumClass, int ordinal) {
        if (enumClass == null) {
            return null;
        }
        if (!enumClass.isEnum()) {
            return null;
        }
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (ordinal >= 0 && ordinal < enumConstants.length) {
            return (T)enumConstants[ordinal];
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnumByName(Class<?> enumClass, String name) {
        if (enumClass == null) {
            return null;
        }
        if (!enumClass.isEnum()) {
            return null;
        }
        try {
            return (T)Enum.valueOf(enumClass, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

