/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.utils;

import com.neko233.json.utils.CollectionUtilsForJson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtilsForJson {
    private static final Logger log = LoggerFactory.getLogger(StringUtilsForJson.class);
    public static final int INDEX_NOT_FOUND = -1;
    public static final char C_SPACE = ' ';
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int MAX_HANDLE_STRING = 8192;
    private static final char C_SLASH = '/';
    private static final char C_BACKSLASH = '\\';
    private static final String EMPTY_JSON = "{}";

    public static String trim(String input) {
        if (StringUtilsForJson.isBlank(input)) {
            return EMPTY;
        }
        return input.trim();
    }

    public static boolean isEmpty(char ... cs) {
        return StringUtilsForJson.isEmpty(new String(cs));
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtilsForJson.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtilsForJson.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtilsForJson.isBlank(cs);
    }

    public static String firstWordUpperCase(String content) {
        if (StringUtilsForJson.isBlank(content)) {
            return content;
        }
        if (content.length() == 1) {
            return content.toUpperCase();
        }
        return content.substring(0, 1).toUpperCase() + content.substring(1);
    }

    public static String firstWordLowerCase(String content) {
        if (StringUtilsForJson.isBlank(content)) {
            return content;
        }
        if (content.length() == 1) {
            return content.toLowerCase();
        }
        return content.substring(0, 1).toLowerCase() + content.substring(1);
    }

    public static String toBigCamelCaseUpper(String name) {
        StringBuilder builder = new StringBuilder();
        char[] chars = name.toCharArray();
        if (chars.length == 0) {
            return name;
        }
        builder.append(chars[0]);
        for (int index = 1; index < chars.length; ++index) {
            char aChar = chars[index];
            boolean upperCase = Character.isUpperCase(aChar);
            if (upperCase) {
                builder.append("_").append(aChar);
                continue;
            }
            char upperChar = Character.toUpperCase(aChar);
            builder.append(upperChar);
        }
        return builder.toString();
    }

    public static String toBigCamelCaseLower(String name) {
        StringBuilder builder = new StringBuilder();
        char[] chars = name.toCharArray();
        if (chars.length == 0) {
            return name;
        }
        builder.append(Character.toLowerCase(chars[0]));
        for (int index = 1; index < chars.length; ++index) {
            char aChar = chars[index];
            boolean upperCase = Character.isUpperCase(aChar);
            if (upperCase) {
                builder.append("_").append(Character.toLowerCase(aChar));
                continue;
            }
            char upperChar = Character.toLowerCase(aChar);
            builder.append(upperChar);
        }
        return builder.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String truncate(String str, int maxWidth) {
        return StringUtilsForJson.truncate(str, 0, maxWidth);
    }

    public static String truncate(String str, int offset, int maxWidth) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            int ix = Math.min(offset + maxWidth, str.length());
            return str.substring(offset, ix);
        }
        return str.substring(offset);
    }

    public static String upperCase(String str) {
        return StringUtilsForJson.upperCase(str, null);
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        if (locale == null) {
            return str.toUpperCase();
        }
        return str.toUpperCase(locale);
    }

    public static String lowerCase(String str) {
        return StringUtilsForJson.lowerCase(str, null);
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        if (locale == null) {
            return str.toLowerCase();
        }
        return str.toLowerCase(locale);
    }

    public static String splitTrimThenJoin(String s, String separator) {
        String notNullStr = Optional.of(s).orElse(EMPTY);
        return Arrays.stream(notNullStr.split(separator)).map(String::trim).filter(StringUtilsForJson::isNotBlank).collect(Collectors.joining(separator));
    }

    public static String join(CharSequence delimiter, Object ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (Object obj : elements) {
            joiner.add(String.valueOf(obj));
        }
        return joiner.toString();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtilsForJson.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtilsForJson.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return CollectionUtilsForJson.isNotEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static void appendByPrintStyle(StringBuilder builder, String key, Object value) {
        builder.append(key).append(value).append(LF);
    }

    public static String format(String strPattern, Object ... argArray) {
        return StringUtilsForJson.template(strPattern, EMPTY_JSON, argArray);
    }

    public static String template(String pattern, String placeHolder, Object ... argArray) {
        if (StringUtilsForJson.isBlank(pattern) || StringUtilsForJson.isBlank(placeHolder) || argArray == null) {
            return pattern;
        }
        int strPatternLength = pattern.length();
        int placeHolderLength = placeHolder.length();
        StringBuilder sbuf = new StringBuilder(strPatternLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < argArray.length; ++argIndex) {
            int delimIndex = pattern.indexOf(placeHolder, handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return pattern;
                }
                sbuf.append(pattern, handledPosition, strPatternLength);
                return sbuf.toString();
            }
            if (delimIndex > 0 && pattern.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && pattern.charAt(delimIndex - 2) == '\\') {
                    sbuf.append(pattern, handledPosition, delimIndex - 1);
                    sbuf.append(String.valueOf(argArray[argIndex]));
                    handledPosition = delimIndex + placeHolderLength;
                    continue;
                }
                --argIndex;
                sbuf.append(pattern, handledPosition, delimIndex - 1);
                sbuf.append(placeHolder.charAt(0));
                handledPosition = delimIndex + 1;
                continue;
            }
            sbuf.append(pattern, handledPosition, delimIndex);
            sbuf.append(argArray[argIndex]);
            handledPosition = delimIndex + placeHolderLength;
        }
        sbuf.append(pattern, handledPosition, strPatternLength);
        return sbuf.toString();
    }
}

