/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectionUtilsForJson {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtilsForJson.isEmpty(collection);
    }

    public static <T> Collection<T> addAll(List<T> es, Enumeration<T> networkInterfaces) {
        if (networkInterfaces == null) {
            return es;
        }
        if (es == null) {
            es = new ArrayList<T>();
        }
        while (networkInterfaces.hasMoreElements()) {
            es.add(networkInterfaces.nextElement());
        }
        return es;
    }

    static int checkSizeNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    @SafeVarargs
    public static <V> List<V> ofList(V ... objs) {
        if (objs == null) {
            return new ArrayList(0);
        }
        return Arrays.stream(objs).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <V> Set<V> ofSet(V ... objs) {
        if (objs == null) {
            return new HashSet(0);
        }
        return Arrays.stream(objs).collect(Collectors.toSet());
    }
}

