/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.utils;

import com.neko233.json.utils.ListUtilsForJson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextTokenUtils {
    public static String removeCharInTargetRange(String input) {
        return TextTokenUtils.removeCharInTargetRange(input, ListUtilsForJson.of(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf(' ')), ListUtilsForJson.of(Character.valueOf('\''), Character.valueOf('\"')));
    }

    public static String removeCharInTargetRange(String input, List<Character> toRemoveCharList, List<Character> specialCharArray) {
        StringBuilder result = new StringBuilder();
        HashMap<Character, Boolean> stateMap = new HashMap<Character, Boolean>();
        for (Character character : specialCharArray) {
            stateMap.put(character, false);
        }
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            Boolean isInState = (Boolean)stateMap.get(Character.valueOf(c));
            boolean isInAnyState = TextTokenUtils.isInAnyState(stateMap);
            if (specialCharArray.contains(Character.valueOf(c))) {
                result.append(c);
                stateMap.put(Character.valueOf(c), isInState == false);
                continue;
            }
            if (isInAnyState) {
                result.append(c);
                continue;
            }
            if (isInState != null || toRemoveCharList.contains(Character.valueOf(c))) continue;
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isInAnyState(Map<Character, Boolean> stateMap) {
        return stateMap.values().stream().anyMatch(b -> b);
    }
}

