package com.neko233.json.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @author SolarisNeko
 * Date on 2023-10-29
 */
public class ClassUtilsForJson {


    /**
     * 获取所有 getter 方法
     *
     * @param obj 对象
     * @return Map
     */
    public static Map<String, Method> getGetterMap(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        Map<String, Method> properties = new HashMap<>();

        for (Method method : methods) {

            String methodName = method.getName();
            if (methodName.startsWith("get") && method.getReturnType() != void.class) {
                String fieldNameFirstBig = methodName.replaceFirst("get", "");
                if (StringUtilsForJson.isBlank(fieldNameFirstBig)) {
                    continue;
                }
                String propertyName = StringUtilsForJson.firstWordLowerCase(fieldNameFirstBig);
                properties.put(propertyName, method);
            }
        }

        return properties;
    }

    /**
     * 获取所有 setter 方法
     *
     * @param obj 对象
     * @return Map
     */
    public static Map<String, Method> getSetterMap(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        Map<String, Method> properties = new HashMap<>();

        for (Method method : methods) {
            String methodName = method.getName();
            if (methodName.equalsIgnoreCase("set")) {
                continue;
            }

            if (methodName.startsWith("set") && method.getParameterCount() == 1) {
                String fieldNameFirstBig = methodName.replaceFirst("set", "");
                if (StringUtilsForJson.isBlank(fieldNameFirstBig)) {
                    continue;
                }
                String propertyName = StringUtilsForJson.firstWordLowerCase(fieldNameFirstBig);
                properties.put(propertyName, method);
            }
        }

        return properties;
    }


}
