/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json;

import com.neko233.json.Json233;
import com.neko233.json.data.DateData;
import com.neko233.json.data.SetElement;
import com.neko233.json.data.SubAction;
import com.neko233.json.data.TestSpeedPerson;
import com.neko233.json.enumData.EnumProperty;
import com.neko233.json.enumData.EnumUser;
import com.neko233.json.parameterizedData.ParameterizedUser;
import com.neko233.json.typeRef.JsonTypeRef;
import com.neko233.json.utils.ListUtilsForJson;
import com.neko233.skilltree.commons.core.base.MapUtils233;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Json233Test {
    TestSpeedPerson testSpeedPerson;

    public Json233Test() {
        HashSet<SetElement> setElementSet = new HashSet<SetElement>();
        setElementSet.add(SetElement.builder().money(100.01).build());
        this.testSpeedPerson = TestSpeedPerson.builder().name("neko233").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a1").build(), SubAction.builder().name("a2").build()})).setElementSet(setElementSet).build();
    }

    @Test
    public void serialize_pretty() {
        String json = Json233.serializePretty((Object)this.testSpeedPerson);
        System.out.println(json);
        Assert.assertEquals((Object)"{\n\t\"age\": 18,\n\t\"name\": \"neko233\",\n\t\"setElementSet\": [\n\t\t{\n\t\t\t\"money\": 100.01\n\t\t}\n\t],\n\t\"subActionList\": [\n\t\t{\n\t\t\t\"name\": \"a1\"\n\t\t},\n\t\t{\n\t\t\t\"name\": \"a2\"\n\t\t}\n\t]\n}", (Object)json);
    }

    @Test
    public void serialize() {
        String json = Json233.serialize((Object)this.testSpeedPerson);
        Assert.assertEquals((Object)"{\"age\":18,\"name\":\"neko233\",\"setElementSet\":[{\"money\":100.01}],\"subActionList\":[{\"name\":\"a1\"},{\"name\":\"a2\"}]}", (Object)json);
    }

    @Test
    public void serialize_base_array() {
        List integers = Json233.deserializeArray((String)"[1,2,3]", Integer.class);
        Assert.assertEquals((Object)1, integers.get(0));
        Assert.assertEquals((Object)2, integers.get(1));
    }

    @Test
    public void serialize_date() throws Exception {
        DateData build = DateData.builder().date(new Date(1685548800000L)).localDateTime(LocalDateTime.of(2023, 1, 1, 0, 0, 0)).localDate(LocalDate.of(2023, 1, 1)).nullData(null).build();
        String serialize = Json233.serialize((Object)build);
        Assert.assertEquals((Object)"{\"date\":\"2023-06-01 00:00:00\",\"localDate\":\"2023-01-01 00:00:00\",\"localDateTime\":\"2023-01-01 00:00:00\",\"nullData\":null}", (Object)serialize);
        DateData reTestSpeedPerson = (DateData)Json233.deserialize((String)serialize, DateData.class);
        Assert.assertEquals((long)1685548800000L, (long)reTestSpeedPerson.getDate().getTime());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Assert.assertEquals((Object)"2023-01-01 00:00:00", (Object)reTestSpeedPerson.getLocalDateTime().format(formatter));
    }

    @Test
    public void testDeserialize() throws Exception {
        String serialize = Json233.serialize((Object)this.testSpeedPerson);
        TestSpeedPerson reTestSpeedPerson = (TestSpeedPerson)Json233.deserialize((String)serialize, TestSpeedPerson.class);
        System.out.println("original = " + this.testSpeedPerson);
        System.out.println("deserialize = " + reTestSpeedPerson);
        Assert.assertTrue((boolean)reTestSpeedPerson.equals(this.testSpeedPerson));
    }

    @Test
    public void serialize_Array() {
        List of = ListUtilsForJson.of((Object[])new String[]{"a", "b"});
        String serialize = Json233.serialize((Object)of);
        Assert.assertEquals((Object)"[\"a\",\"b\"]", (Object)serialize);
    }

    @Test
    public void deserialize_Array() throws Exception {
        String json = "[\"a\",\"b\"]";
        List deserialize = Json233.deserializeArray((String)json, String.class);
        Assert.assertEquals((Object)"a", deserialize.get(0));
    }

    @Test
    public void serialize_objArray() {
        List of = ListUtilsForJson.of((Object[])new EnumUser[]{EnumUser.builder().userId(1L).enumField(EnumProperty.A).build(), EnumUser.builder().userId(2L).enumField(EnumProperty.B).build()});
        String serialize = Json233.serialize((Object)of);
        Assert.assertEquals((Object)"[{\"enumField\":0,\"userId\":1},{\"enumField\":1,\"userId\":2}]", (Object)serialize);
    }

    @Test
    public void deserialize_objArray() throws Exception {
        String json = "[{\"userId\":1,\"enumField\":\"A\"},{\"userId\":2,\"enumField\":\"B\"}]";
        List deserialize = Json233.deserializeArray((String)json, EnumUser.class);
        Assert.assertEquals((long)1L, (long)((EnumUser)deserialize.get(0)).getUserId());
        Assert.assertEquals((Object)((Object)EnumProperty.A), (Object)((Object)((EnumUser)deserialize.get(0)).getEnumField()));
        Assert.assertEquals((long)2L, (long)((EnumUser)deserialize.get(1)).getUserId());
        Assert.assertEquals((Object)((Object)EnumProperty.B), (Object)((Object)((EnumUser)deserialize.get(1)).getEnumField()));
    }

    @Test
    public void serialize_parameterizedObj() {
        List of = ListUtilsForJson.of((Object[])new ParameterizedUser[]{ParameterizedUser.builder().userId(1L).data("ok").build()});
        String serialize = Json233.serialize((Object)of);
        Assert.assertEquals((Object)"[{\"data\":\"ok\",\"userId\":1}]", (Object)serialize);
    }

    @Test
    public void deserialize_parameterizedObj() throws Exception {
        String json = "[{\"userId\":1,\"data\":\"ok\"}]";
        JsonTypeRef<ParameterizedUser<String>> jsonTypeRef = new JsonTypeRef<ParameterizedUser<String>>(){};
        ParameterizedUser deserialize = (ParameterizedUser)Json233.deserialize((String)json, (JsonTypeRef)jsonTypeRef);
        Assert.assertEquals((long)1L, (long)deserialize.getUserId());
        Assert.assertEquals((Object)"ok", deserialize.getData());
    }

    @Test
    public void serialize_enum() {
        EnumUser enumUser = new EnumUser();
        enumUser.setEnumField(EnumProperty.B);
        enumUser.setUserId(1L);
        String serialize = Json233.serialize((Object)enumUser);
        Assert.assertEquals((Object)"{\"enumField\":1,\"userId\":1}", (Object)serialize);
    }

    @Test
    public void deserialize_enum() throws Exception {
        String json = "{\"userId\":1,\"enumField\":1}";
        EnumUser deserialize = (EnumUser)Json233.deserialize((String)json, EnumUser.class);
        Assert.assertEquals((long)1L, (long)deserialize.getUserId());
        Assert.assertEquals((Object)((Object)EnumProperty.B), (Object)((Object)deserialize.getEnumField()));
    }

    @Test
    public void jsonToRefMap() throws Exception {
        String json = "{\"userId\":1,\"username\":\"demo\"}";
        Map map = (Map)Json233.deserialize((String)json, (JsonTypeRef)new JsonTypeRef<Map<String, Object>>(){});
        Assert.assertEquals((Object)1L, map.get("userId"));
        Assert.assertEquals((Object)"demo", map.get("username"));
    }

    @Test
    public void jsonToMap() throws Exception {
        String json = "{\"userId\":1,\"username\":\"demo\"}";
        Map map = (Map)Json233.deserialize((String)json, Map.class);
        Assert.assertEquals((Object)1L, map.get("userId"));
        Assert.assertEquals((Object)"demo", map.get("username"));
    }

    @Test
    public void ListToJsonArray() throws Exception {
        List of = ListUtilsForJson.of((Object[])new Map[]{MapUtils233.of((Object[])new Object[]{"username", "a1", "age", 18}), MapUtils233.of((Object[])new Object[]{"username", "a2", "age", 22})});
        String jsonArray = Json233.serialize((Object)of);
        Assert.assertEquals((Object)"[{\"age\":18,\"username\":\"a1\"},{\"age\":22,\"username\":\"a2\"}]", (Object)jsonArray);
        List deserialize = Json233.deserializeArray((String)jsonArray);
        Map kv1 = (Map)deserialize.get(0);
        Assert.assertEquals(kv1.get("username"), (Object)"a1");
        Assert.assertEquals(kv1.get("age"), (Object)18L);
    }

    @Test
    public void ListToJsonArrayWithPretty() throws Exception {
        List of = ListUtilsForJson.of((Object[])new Map[]{MapUtils233.of((Object[])new Object[]{"username", "a1", "age", 18}), MapUtils233.of((Object[])new Object[]{"username", "a2", "age", 22})});
        String jsonArray = Json233.serializePretty((Object)of);
        List deserialize = Json233.deserializeArray((String)jsonArray);
        Map kv1 = (Map)deserialize.get(0);
        Assert.assertEquals(kv1.get("username"), (Object)"a1");
        Assert.assertEquals(kv1.get("age"), (Object)18L);
    }
}

