/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json;

import com.neko233.json.Json233;
import com.neko233.json.data.SetElement;
import com.neko233.json.data.SubAction;
import com.neko233.json.data.TestSpeedPerson;
import com.neko233.json.utils.ListUtilsForJson;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@Warmup(iterations=3, time=1)
@Measurement(iterations=5, time=5)
@Threads(value=4)
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class JsonJmhTest {
    TestSpeedPerson testSpeedPerson;
    List<TestSpeedPerson> testSpeedPersonList;

    public JsonJmhTest() {
        HashSet<SetElement> setElementSet = new HashSet<SetElement>();
        setElementSet.add(SetElement.builder().money(100.01).build());
        this.testSpeedPerson = TestSpeedPerson.builder().name("neko233").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a1").build(), SubAction.builder().name("a2").build()})).setElementSet(setElementSet).build();
        this.testSpeedPersonList = ListUtilsForJson.of((Object[])new TestSpeedPerson[]{TestSpeedPerson.builder().name("neko233").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a1").build(), SubAction.builder().name("a2").build()})).setElementSet(setElementSet).build(), TestSpeedPerson.builder().name("2").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a12").build(), SubAction.builder().name("a23").build()})).setElementSet(setElementSet).build(), TestSpeedPerson.builder().name("1234").age(432531).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("34").build(), SubAction.builder().name("23").build()})).setElementSet(setElementSet).build()});
    }

    public static void main(String[] args) throws RunnerException {
        new Runner(new OptionsBuilder().include(JsonJmhTest.class.getSimpleName()).resultFormat(ResultFormatType.JSON).result("jmh-result-by-ms.json").build()).run();
    }

    @Benchmark
    public void test_array_speed_just_serialize() {
        Json233.serialize(this.testSpeedPersonList);
    }

    @Benchmark
    public void test_jsonArray_speed_serialize_and_deserialize() throws Exception {
        String serialize = Json233.serialize(this.testSpeedPersonList);
        List reTestSpeedPersonData = Json233.deserializeArray((String)serialize, TestSpeedPerson.class);
    }

    @Benchmark
    public void test_singleObject_speed_serialize_and_deserialize() throws Exception {
        String serialize = Json233.serialize((Object)this.testSpeedPerson);
        TestSpeedPerson reTestSpeedPerson = (TestSpeedPerson)Json233.deserialize((String)serialize, TestSpeedPerson.class);
    }

    @Benchmark
    public void test_singleObject_speed_serialize() throws Exception {
        String serialize = Json233.serialize((Object)this.testSpeedPerson);
    }
}

