/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json;

import com.neko233.json.Json233;
import com.neko233.json.data.SetElement;
import com.neko233.json.data.SubAction;
import com.neko233.json.data.TestSpeedPerson;
import com.neko233.json.utils.ListUtilsForJson;
import java.util.HashSet;
import java.util.List;
import org.junit.Test;

public class JsonSpeedTest {
    TestSpeedPerson testSpeedPerson;
    List<TestSpeedPerson> testSpeedPersonList;

    public JsonSpeedTest() {
        HashSet<SetElement> setElementSet = new HashSet<SetElement>();
        setElementSet.add(SetElement.builder().money(100.01).build());
        this.testSpeedPerson = TestSpeedPerson.builder().name("neko233").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a1").build(), SubAction.builder().name("a2").build()})).setElementSet(setElementSet).build();
        this.testSpeedPersonList = ListUtilsForJson.of((Object[])new TestSpeedPerson[]{TestSpeedPerson.builder().name("neko233").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a1").build(), SubAction.builder().name("a2").build()})).setElementSet(setElementSet).build(), TestSpeedPerson.builder().name("2").age(18).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("a12").build(), SubAction.builder().name("a23").build()})).setElementSet(setElementSet).build(), TestSpeedPerson.builder().name("1234").age(432531).subActionList(ListUtilsForJson.of((Object[])new SubAction[]{SubAction.builder().name("34").build(), SubAction.builder().name("23").build()})).setElementSet(setElementSet).build()});
    }

    @Test
    public void test_array_speed_just_serialize() {
        long endMs;
        for (int i = 0; i < 10000; ++i) {
            Json233.serialize(this.testSpeedPersonList);
        }
        int count = 0;
        long startMs = System.currentTimeMillis();
        do {
            Json233.serialize(this.testSpeedPersonList);
            ++count;
        } while ((endMs = System.currentTimeMillis()) - startMs <= 1000L);
        System.out.println("object List  serialize.  \u9884\u70ed\u540e, 1s \u53ef\u6267\u884c count = " + count);
    }

    @Test
    public void test_jsonArray_speed_serialize_and_deserialize() throws Exception {
        long endMs;
        for (int i = 0; i < 10000; ++i) {
            String serialize = Json233.serialize(this.testSpeedPersonList);
            List list = Json233.deserializeArray((String)serialize, TestSpeedPerson.class);
        }
        int count = 0;
        long startMs = System.currentTimeMillis();
        do {
            String serialize = Json233.serialize(this.testSpeedPersonList);
            List reTestSpeedPersonData = Json233.deserializeArray((String)serialize, TestSpeedPerson.class);
            ++count;
        } while ((endMs = System.currentTimeMillis()) - startMs <= 1000L);
        System.out.println("object List  serialize + deserialize. \u9884\u70ed\u540e, 1s \u53ef\u6267\u884c count = " + count);
    }

    @Test
    public void test_singleObject_speed_serialize_and_deserialize() throws Exception {
        long endMs;
        for (int i = 0; i < 10000; ++i) {
            String serialize = Json233.serialize((Object)this.testSpeedPerson);
            TestSpeedPerson testSpeedPerson = (TestSpeedPerson)Json233.deserialize((String)serialize, TestSpeedPerson.class);
        }
        int count = 0;
        long startMs = System.currentTimeMillis();
        do {
            String serialize = Json233.serialize((Object)this.testSpeedPerson);
            TestSpeedPerson reTestSpeedPerson = (TestSpeedPerson)Json233.deserialize((String)serialize, TestSpeedPerson.class);
            ++count;
        } while ((endMs = System.currentTimeMillis()) - startMs <= 1000L);
        System.out.println("single object. \u9884\u70ed\u540e, 1s \u53ef\u6267\u884c serialize + deserialize count = " + count);
    }

    @Test
    public void test_singleObject_speed_serialize() throws Exception {
        long endMs;
        for (int i = 0; i < 10000; ++i) {
            String string = Json233.serialize((Object)this.testSpeedPerson);
        }
        int count = 0;
        long startMs = System.currentTimeMillis();
        do {
            String serialize = Json233.serialize((Object)this.testSpeedPerson);
            ++count;
        } while ((endMs = System.currentTimeMillis()) - startMs <= 1000L);
        System.out.println("\u9884\u70ed\u540e, 1s \u53ef\u6267\u884c serialize + deserialize count = " + count);
    }
}

