/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.serializer;

import com.neko233.json.convert.JsonConfig;
import com.neko233.json.utils.ClassUtilsForJson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00");
    private JsonConfig jsonConfig;

    public JsonSerializer(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }

    public String serialize(Object obj) {
        StringBuilder jsonBuilder = new StringBuilder();
        this.serialize(obj, jsonBuilder);
        return jsonBuilder.toString();
    }

    private void serialize(Object obj, StringBuilder jsonBuilder) {
        if (obj == null) {
            jsonBuilder.append("null");
            return;
        }
        if (obj instanceof String) {
            jsonBuilder.append("\"").append(this.escapeString((String)obj)).append("\"");
            return;
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            jsonBuilder.append(obj.toString());
            return;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = simpleDateFormat.format(date);
            jsonBuilder.append("\"").append(this.escapeString(dateStr)).append("\"");
            return;
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)obj;
            String format = dateTime.format(DATE_TIME_FORMATTER);
            jsonBuilder.append("\"").append(this.escapeString(format)).append("\"");
            return;
        }
        if (obj instanceof LocalDate) {
            LocalDate dateTime = (LocalDate)obj;
            String format = dateTime.format(DATE_FORMATTER);
            jsonBuilder.append("\"").append(this.escapeString(format)).append("\"");
            return;
        }
        if (obj instanceof Collection) {
            this.serializeCollection((Collection)obj, jsonBuilder);
            return;
        }
        if (obj instanceof Map) {
            this.serializeMap((Map)obj, jsonBuilder);
            return;
        }
        this.serializeObject(obj, jsonBuilder);
    }

    private void serializeEnum(Enum<?> obj, StringBuilder jsonBuilder) {
        jsonBuilder.append("{");
        String escapeKey = this.escapeString(obj.name());
        jsonBuilder.append("\"").append(escapeKey).append("\":").append(obj.ordinal());
        jsonBuilder.append("}");
    }

    private void serializeCollection(Collection<?> collection, StringBuilder jsonBuilder) {
        jsonBuilder.append("[");
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            this.serialize(item, jsonBuilder);
        }
        jsonBuilder.append("]");
    }

    private void serializeMap(Map<?, ?> map, StringBuilder jsonBuilder) {
        jsonBuilder.append("{");
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                jsonBuilder.append(",");
            }
            jsonBuilder.append("\"").append(this.escapeString(entry.getKey().toString())).append("\":");
            this.serialize(entry.getValue(), jsonBuilder);
        }
        jsonBuilder.append("}");
    }

    private void serializeObject(Object obj, StringBuilder jsonBuilder) {
        String jsonKey;
        Object value;
        jsonBuilder.append("{");
        TreeMap<String, Object> keyToValueMap = new TreeMap<String, Object>();
        Map<String, Method> getterMap = ClassUtilsForJson.getGetterMap(obj);
        for (String fieldName : getterMap.keySet()) {
            Method getter = getterMap.get(fieldName);
            getter.setAccessible(true);
            value = null;
            try {
                value = getter.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (value == obj) continue;
            jsonKey = this.escapeString(fieldName);
            keyToValueMap.put(jsonKey, value);
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object value2;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                value2 = field.get(obj);
            }
            catch (Exception e) {
                continue;
            }
            if (value2 instanceof Enum) {
                value2 = ((Enum)value2).ordinal();
            }
            String fieldName = field.getName();
            if (value2 == obj) continue;
            keyToValueMap.put(fieldName, value2);
        }
        boolean isFirst = true;
        for (String fieldName : keyToValueMap.keySet()) {
            value = keyToValueMap.get(fieldName);
            if (isFirst) {
                isFirst = false;
            } else {
                jsonBuilder.append(",");
            }
            jsonKey = this.escapeString(fieldName);
            jsonBuilder.append("\"").append(jsonKey).append("\":");
            this.serialize(value, jsonBuilder);
        }
        jsonBuilder.append("}");
    }

    private String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

