/*
 * Decompiled with CFR 0.152.
 */
package com.neko233.json.utils;

import com.neko233.json.convert.DefaultJsonConfig;
import com.neko233.json.convert.JsonConfig;
import com.neko233.json.exception.DeserializeJsonException;
import com.neko233.json.utils.EnumUtilsForJson;
import com.neko233.json.utils.StringUtilsForJson;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanJsonOrmUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanJsonOrmUtils.class);
    public static final String DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMATTER = "yyyy-MM-dd 00:00:00";

    public static <T> T mapToBeanAny(Map<String, Object> map, Class<?> clazz) throws Exception {
        return BeanJsonOrmUtils.mapToBean(map, clazz, null);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz) throws Exception {
        if (clazz == Map.class) {
            return (T)map;
        }
        return BeanJsonOrmUtils.mapToBean(map, clazz, null);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz, JsonConfig config) throws Exception {
        JsonConfig jsonConfig = config = config == null ? DefaultJsonConfig.instance : config;
        if (clazz == String.class || Number.class.isAssignableFrom(clazz)) {
            Object o = map.get("@default");
            return (T)config.castValueToClassType(o, clazz);
        }
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        constructor.setAccessible(true);
        Object instance = constructor.newInstance(new Object[0]);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String jsonName = entry.getKey();
            Object jsonValue = entry.getValue();
            try {
                Field field = clazz.getDeclaredField(jsonName);
                field.setAccessible(true);
                Object convertedValue = BeanJsonOrmUtils.convertValue(field, jsonValue, config);
                field.set(instance, convertedValue);
            }
            catch (NoSuchFieldException e) {
                config.handleException(e);
            }
        }
        return (T)instance;
    }

    private static Object convertValue(Field field, Object jsonValue, JsonConfig config) throws Exception {
        Object formatter;
        Type[] actualTypeArguments;
        ParameterizedType parameterizedType;
        Type genericType;
        if (jsonValue == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        Object fieldValue = config.handleByYourDiyType(fieldType, jsonValue);
        if (fieldValue != null) {
            return fieldValue;
        }
        Class<?> jsonType = jsonValue.getClass();
        if (fieldType.isEnum()) {
            if (jsonValue instanceof String) {
                return EnumUtilsForJson.getEnumByName(fieldType, String.valueOf(jsonValue));
            }
            if (jsonValue instanceof Number) {
                int ordinal = Integer.parseInt(StringUtilsForJson.trim(String.valueOf(jsonValue)));
                return EnumUtilsForJson.getEnumByOrdinal(fieldType, ordinal);
            }
            return null;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            Type[] actualTypeArguments2;
            genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (actualTypeArguments2 = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && actualTypeArguments2[0] instanceof Class) {
                Class listElementType = (Class)actualTypeArguments2[0];
                List jsonValueList = (List)jsonValue;
                return jsonValueList.stream().map(obj -> {
                    try {
                        return BeanJsonOrmUtils.mapToBeanAny(obj, listElementType);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            }
        } else if (Set.class.isAssignableFrom(fieldType)) {
            Type[] actualTypeArguments3;
            genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (actualTypeArguments3 = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && actualTypeArguments3[0] instanceof Class) {
                Class setElementType = (Class)actualTypeArguments3[0];
                List jsonValueList = (List)jsonValue;
                return jsonValueList.stream().map(obj -> {
                    try {
                        return BeanJsonOrmUtils.mapToBeanAny(obj, setElementType);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toSet());
            }
        } else if (Map.class.isAssignableFrom(fieldType)) {
            Type[] actualTypeArguments4;
            genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType && (actualTypeArguments4 = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 2 && actualTypeArguments4[0] instanceof Class && actualTypeArguments4[1] instanceof Class) {
                Class mapKeyType = (Class)actualTypeArguments4[0];
                Class mapValueType = (Class)actualTypeArguments4[1];
                if (Map.class.isAssignableFrom(jsonValue.getClass())) {
                    Map jsonMap = (Map)jsonValue;
                    HashMap<Object, Object> convertedMap = new HashMap<Object, Object>();
                    for (Map.Entry entry : jsonMap.entrySet()) {
                        Object key = BeanJsonOrmUtils.convertValue(field, entry.getKey(), config);
                        Object value = BeanJsonOrmUtils.convertValue(field, entry.getValue(), config);
                        convertedMap.put(key, value);
                    }
                    return convertedMap;
                }
            }
        } else if (Queue.class.isAssignableFrom(fieldType) && (genericType = field.getGenericType()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && actualTypeArguments[0] instanceof Class) {
            Class queueElementType = (Class)actualTypeArguments[0];
            if (Queue.class.isAssignableFrom(jsonValue.getClass())) {
                Queue jsonQueue = (Queue)jsonValue;
                LinkedList<Object> convertedQueue = new LinkedList<Object>();
                for (Object item : jsonQueue) {
                    convertedQueue.offer(BeanJsonOrmUtils.convertValue(field, item, config));
                }
                return convertedQueue;
            }
        }
        if (fieldType.isAssignableFrom(jsonType)) {
            return jsonValue;
        }
        if (config.isConversionSupported(fieldType)) {
            return config.convertValue(fieldType, jsonValue);
        }
        if ((fieldType == Short.class || fieldType == Short.TYPE) && jsonValue instanceof Long) {
            return Short.parseShort(String.valueOf(jsonValue));
        }
        if ((fieldType == Integer.class || fieldType == Integer.TYPE) && jsonValue instanceof Long) {
            return Integer.parseInt(String.valueOf(jsonValue));
        }
        if ((fieldType == Long.class || fieldType == Long.TYPE) && jsonValue instanceof Long) {
            return jsonValue;
        }
        if ((fieldType == Float.class || fieldType == Float.TYPE) && jsonValue instanceof Double) {
            return Float.valueOf(Float.parseFloat(String.valueOf(jsonValue)));
        }
        if ((fieldType == Double.class || fieldType == Double.TYPE) && jsonValue instanceof Double) {
            return Double.parseDouble(String.valueOf(jsonValue));
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            if (jsonValue instanceof Boolean) {
                return jsonValue;
            }
            return null;
        }
        if (fieldType == Date.class) {
            if (jsonValue instanceof String) {
                formatter = new SimpleDateFormat(DATE_TIME_FORMATTER);
                try {
                    return ((DateFormat)formatter).parse(String.valueOf(jsonValue));
                }
                catch (ParseException e) {
                    throw new DeserializeJsonException(e, "date \u7684 string \u683c\u5f0f\u4e0d\u662f yyyy-MM-dd HH:mm:ss. jsonValue = {}", jsonValue);
                }
            }
            if (jsonValue instanceof Long) {
                return new Date((Long)jsonValue);
            }
            return null;
        }
        if (fieldType == LocalDateTime.class) {
            if (jsonValue instanceof String) {
                formatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMATTER);
                return LocalDateTime.parse(jsonValue.toString(), (DateTimeFormatter)formatter);
            }
            if (jsonValue instanceof Long) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)jsonValue), ZoneId.systemDefault());
            }
            return null;
        }
        if (fieldType == LocalDate.class) {
            if (jsonValue instanceof String) {
                formatter = DateTimeFormatter.ofPattern(DATE_FORMATTER);
                return LocalDate.parse(jsonValue.toString(), (DateTimeFormatter)formatter);
            }
            return null;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8f6c\u6362\u7c7b\u578b. \u9700\u8981\u5728 jsonConfig \u4e2d\u5b9a\u5236\u5904\u7406. Unsupported conversion from " + jsonValue.getClass() + " to " + fieldType);
    }
}

