/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.ForIterator;
import com.fizzed.rocker.runtime.PrimitiveCollections;
import java.util.Collection;
import java.util.Iterator;

public class CollectionForIterator<T>
implements ForIterator {
    private final Iterator<?> iterator;
    private int index;
    private final int size;

    public CollectionForIterator(Collection<?> c) {
        this(c.iterator(), c.size());
    }

    public CollectionForIterator(Object[] a) {
        this(new PrimitiveCollections.ObjectCollection(a));
    }

    public CollectionForIterator(boolean[] a) {
        this(new PrimitiveCollections.BooleanCollection(a));
    }

    public CollectionForIterator(byte[] a) {
        this(new PrimitiveCollections.ByteCollection(a));
    }

    public CollectionForIterator(char[] a) {
        this(new PrimitiveCollections.CharacterCollection(a));
    }

    public CollectionForIterator(short[] a) {
        this(new PrimitiveCollections.ShortCollection(a));
    }

    public CollectionForIterator(int[] a) {
        this(new PrimitiveCollections.IntegerCollection(a));
    }

    public CollectionForIterator(long[] a) {
        this(new PrimitiveCollections.LongCollection(a));
    }

    public CollectionForIterator(float[] a) {
        this(new PrimitiveCollections.FloatCollection(a));
    }

    public CollectionForIterator(double[] a) {
        this(new PrimitiveCollections.DoubleCollection(a));
    }

    public CollectionForIterator(Iterator<?> iterator, int size) {
        this.iterator = iterator;
        this.index = -1;
        this.size = size;
    }

    public T next() {
        Object t = this.iterator.next();
        ++this.index;
        return (T)t;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public boolean first() {
        return this.index == 0;
    }

    @Override
    public boolean last() {
        return this.index == this.size - 1;
    }
}

