/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenImplArray;
import com.jsoniter.CodegenImplEnum;
import com.jsoniter.CodegenImplMap;
import com.jsoniter.CodegenImplNative;
import com.jsoniter.CodegenImplObjectHash;
import com.jsoniter.CodegenImplObjectStrict;
import com.jsoniter.DecodingMode;
import com.jsoniter.DynamicCodegen;
import com.jsoniter.JsonIterator;
import com.jsoniter.ReflectionDecoderFactory;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Extension;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.ParameterizedTypeImpl;
import com.jsoniter.spi.StaticCodegenTarget;
import com.jsoniter.spi.TypeLiteral;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Codegen {
    private static final Set<String> generatedClassNames = new HashSet<String>();
    static StaticCodegenTarget isDoingStaticCodegen = null;
    static DecodingMode mode = DecodingMode.REFLECTION_MODE;

    Codegen() {
    }

    public static void setMode(DecodingMode mode) {
        Codegen.mode = mode;
    }

    static Decoder getDecoder(String cacheKey, Type type) {
        Decoder decoder = JsoniterSpi.getDecoder(cacheKey);
        if (decoder != null) {
            return decoder;
        }
        return Codegen.gen(cacheKey, type);
    }

    private static synchronized Decoder gen(String cacheKey, Type type) {
        Class clazz;
        Object[] typeArgs;
        Decoder decoder;
        block15: {
            decoder = JsoniterSpi.getDecoder(cacheKey);
            if (decoder != null) {
                return decoder;
            }
            List<Extension> extensions = JsoniterSpi.getExtensions();
            for (Extension extension : extensions) {
                type = extension.chooseImplementation(type);
            }
            type = Codegen.chooseImpl(type);
            for (Extension extension : extensions) {
                decoder = extension.createDecoder(cacheKey, type);
                if (decoder == null) continue;
                JsoniterSpi.addNewDecoder(cacheKey, decoder);
                return decoder;
            }
            typeArgs = new Type[]{};
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                clazz = (Class)pType.getRawType();
                typeArgs = pType.getActualTypeArguments();
            } else {
                clazz = (Class)type;
            }
            decoder = CodegenImplNative.NATIVE_DECODERS.get(clazz);
            if (decoder != null) {
                return decoder;
            }
            Codegen.addPlaceholderDecoderToSupportRecursiveStructure(cacheKey);
            if (mode == DecodingMode.REFLECTION_MODE) {
                decoder = ReflectionDecoderFactory.create(clazz, (Type[])typeArgs);
                JsoniterSpi.addNewDecoder(cacheKey, decoder);
                return decoder;
            }
            if (isDoingStaticCodegen == null) {
                try {
                    decoder = (Decoder)Class.forName(cacheKey).newInstance();
                    JsoniterSpi.addNewDecoder(cacheKey, decoder);
                    return decoder;
                }
                catch (Exception e) {
                    if (mode != DecodingMode.STATIC_MODE) break block15;
                    throw new JsonException("static gen should provide the decoder we need, but failed to create the decoder", e);
                }
            }
        }
        String source = Codegen.genSource(clazz, (Type[])typeArgs);
        source = "public static java.lang.Object decode_(com.jsoniter.JsonIterator iter) throws java.io.IOException { " + source + "}";
        if ("true".equals(System.getenv("JSONITER_DEBUG"))) {
            System.out.println(">>> " + cacheKey);
            System.out.println(source);
        }
        try {
            generatedClassNames.add(cacheKey);
            if (isDoingStaticCodegen == null) {
                decoder = DynamicCodegen.gen(cacheKey, source);
            } else {
                Codegen.staticGen(cacheKey, source);
            }
            JsoniterSpi.addNewDecoder(cacheKey, decoder);
            return decoder;
        }
        catch (Exception e) {
            String msg = "failed to generate decoder for: " + type + " with " + Arrays.toString(typeArgs) + ", exception: " + e;
            msg = msg + "\n" + source;
            throw new JsonException(msg, e);
        }
    }

    private static void addPlaceholderDecoderToSupportRecursiveStructure(final String cacheKey) {
        JsoniterSpi.addNewDecoder(cacheKey, new Decoder(){

            @Override
            public Object decode(JsonIterator iter) throws IOException {
                return JsoniterSpi.getDecoder(cacheKey).decode(iter);
            }
        });
    }

    public static boolean canStaticAccess(String cacheKey) {
        return generatedClassNames.contains(cacheKey);
    }

    private static Type chooseImpl(Type type) {
        Class clazz;
        Type[] typeArgs = new Type[]{};
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            clazz = (Class)pType.getRawType();
            typeArgs = pType.getActualTypeArguments();
        } else {
            clazz = (Class)type;
        }
        Class implClazz = JsoniterSpi.getTypeImplementation(clazz);
        if (Collection.class.isAssignableFrom(clazz)) {
            Object compType = Object.class;
            if (typeArgs.length != 0) {
                if (typeArgs.length == 1) {
                    compType = typeArgs[0];
                } else {
                    throw new IllegalArgumentException("can not bind to generic collection without argument types, try syntax like TypeLiteral<List<Integer>>{}");
                }
            }
            if (clazz == List.class) {
                clazz = implClazz == null ? ArrayList.class : implClazz;
            } else if (clazz == Set.class) {
                clazz = implClazz == null ? HashSet.class : implClazz;
            }
            return new ParameterizedTypeImpl(new Type[]{compType}, null, clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Object keyType = String.class;
            Object valueType = Object.class;
            if (typeArgs.length != 0) {
                if (typeArgs.length == 2) {
                    keyType = typeArgs[0];
                    valueType = typeArgs[1];
                } else {
                    throw new IllegalArgumentException("can not bind to generic collection without argument types, try syntax like TypeLiteral<Map<String, String>>{}");
                }
            }
            if (keyType != String.class) {
                throw new IllegalArgumentException("map key must be String");
            }
            if (clazz == Map.class) {
                clazz = implClazz == null ? HashMap.class : implClazz;
            }
            return new ParameterizedTypeImpl(new Type[]{keyType, valueType}, null, clazz);
        }
        if (implClazz != null) {
            if (typeArgs.length == 0) {
                return implClazz;
            }
            return new ParameterizedTypeImpl(typeArgs, null, implClazz);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void staticGen(String cacheKey, String source) throws IOException {
        Codegen.createDir(cacheKey);
        String fileName = cacheKey.replace('.', '/') + ".java";
        FileOutputStream fileOutputStream = new FileOutputStream(new File(Codegen.isDoingStaticCodegen.outputDir, fileName));
        try {
            OutputStreamWriter writer = new OutputStreamWriter(fileOutputStream);
            try {
                Codegen.staticGen(cacheKey, writer, source);
            }
            finally {
                writer.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private static void staticGen(String cacheKey, OutputStreamWriter writer, String source) throws IOException {
        String className = cacheKey.substring(cacheKey.lastIndexOf(46) + 1);
        String packageName = cacheKey.substring(0, cacheKey.lastIndexOf(46));
        writer.write("package " + packageName + ";\n");
        writer.write("public class " + className + " implements com.jsoniter.spi.Decoder {\n");
        writer.write(source);
        writer.write("public java.lang.Object decode(com.jsoniter.JsonIterator iter) throws java.io.IOException {\n");
        writer.write("return decode_(iter);\n");
        writer.write("}\n");
        writer.write("}\n");
    }

    private static void createDir(String cacheKey) {
        String[] parts = cacheKey.split("\\.");
        File parent = new File(Codegen.isDoingStaticCodegen.outputDir);
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            File current = new File(parent, part);
            current.mkdir();
            parent = current;
        }
    }

    private static String genSource(Class clazz, Type[] typeArgs) {
        if (clazz.isArray()) {
            return CodegenImplArray.genArray(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return CodegenImplMap.genMap(clazz, typeArgs);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return CodegenImplArray.genCollection(clazz, typeArgs);
        }
        if (clazz.isEnum()) {
            return CodegenImplEnum.genEnum(clazz);
        }
        ClassDescriptor desc = JsoniterSpi.getDecodingClassDescriptor(clazz, false);
        if (Codegen.shouldUseStrictMode(desc)) {
            return CodegenImplObjectStrict.genObjectUsingStrict(clazz, desc);
        }
        return CodegenImplObjectHash.genObjectUsingHash(clazz, desc);
    }

    private static boolean shouldUseStrictMode(ClassDescriptor desc) {
        if (mode == DecodingMode.DYNAMIC_MODE_AND_MATCH_FIELD_STRICTLY) {
            return true;
        }
        List<Binding> allBindings = desc.allDecoderBindings();
        for (Binding binding : allBindings) {
            if (!binding.asMissingWhenNotPresent && !binding.asExtraWhenPresent && !binding.shouldSkip) continue;
            return true;
        }
        if (desc.asExtraForUnknownProperties) {
            return true;
        }
        return allBindings.isEmpty();
    }

    public static void staticGenDecoders(TypeLiteral[] typeLiterals, StaticCodegenTarget staticCodegenTarget) {
        isDoingStaticCodegen = staticCodegenTarget;
        for (TypeLiteral typeLiteral : typeLiterals) {
            Codegen.gen(typeLiteral.getDecoderCacheKey(), typeLiteral.getType());
        }
    }

    static {
        String envMode = System.getenv("JSONITER_DECODING_MODE");
        if (envMode != null) {
            mode = DecodingMode.valueOf(envMode);
        }
    }
}

