/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import java.io.IOException;
import java.io.OutputStream;

class AsciiOutputStream
extends OutputStream {
    private char[] buf = new char[4096];
    private int count = 0;

    AsciiOutputStream() {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int i = off;
        while (true) {
            if (i < off + len && this.count < this.buf.length) {
                this.buf[this.count++] = (char)b[i];
                ++i;
                continue;
            }
            if (this.count != this.buf.length) break;
            char[] newBuf = new char[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count == this.buf.length) {
            char[] newBuf = new char[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        this.buf[this.count++] = (char)b;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }
}

