/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

class ReflectionMapEncoder
implements Encoder {
    private final TypeLiteral valueTypeLiteral;

    public ReflectionMapEncoder(Class clazz, Type[] typeArgs) {
        this.valueTypeLiteral = typeArgs.length > 1 ? TypeLiteral.create(typeArgs[1]) : TypeLiteral.create(Object.class);
    }

    @Override
    public void encode(Object obj, JsonStream stream) throws IOException {
        if (obj == null) {
            stream.writeNull();
            return;
        }
        Map map = (Map)obj;
        stream.writeObjectStart();
        boolean notFirst = false;
        for (Map.Entry entry : map.entrySet()) {
            if (notFirst) {
                stream.writeMore();
            } else {
                notFirst = true;
            }
            stream.writeObjectField((String)entry.getKey());
            stream.writeVal(this.valueTypeLiteral, entry.getValue());
        }
        stream.writeObjectEnd();
    }

    @Override
    public Any wrap(Object obj) {
        Map map = (Map)obj;
        return Any.wrap(map);
    }
}

