/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;

class ReflectionObjectEncoder
implements Encoder {
    private final ClassDescriptor desc;

    public ReflectionObjectEncoder(Class clazz) {
        this.desc = JsoniterSpi.getEncodingClassDescriptor(clazz, true);
        for (Binding binding : this.desc.allEncoderBindings()) {
            if (binding.encoder != null) continue;
            binding.encoder = JsoniterSpi.getEncoder(binding.encoderCacheKey());
        }
    }

    @Override
    public void encode(Object obj, JsonStream stream) throws IOException {
        try {
            this.enocde_(obj, stream);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public Any wrap(Object obj) {
        HashMap<String, Object> copied = new HashMap<String, Object>();
        try {
            Object val;
            for (Binding field : this.desc.fields) {
                val = field.field.get(obj);
                for (String toName : field.toNames) {
                    copied.put(toName, val);
                }
            }
            for (Binding getter : this.desc.getters) {
                val = getter.method.invoke(obj, new Object[0]);
                for (String toName : getter.toNames) {
                    copied.put(toName, val);
                }
            }
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
        return Any.wrap(copied);
    }

    private void enocde_(Object obj, JsonStream stream) throws Exception {
        Object val;
        if (obj == null) {
            stream.writeNull();
            return;
        }
        stream.writeObjectStart();
        boolean notFirst = false;
        for (Binding field : this.desc.fields) {
            val = field.field.get(obj);
            for (String toName : field.toNames) {
                if (field.shouldOmitNull && val == null) continue;
                if (notFirst) {
                    stream.writeMore();
                } else {
                    notFirst = true;
                }
                stream.writeObjectField(toName);
                if (field.encoder != null) {
                    field.encoder.encode(val, stream);
                    continue;
                }
                stream.writeVal(val);
            }
        }
        for (Binding getter : this.desc.getters) {
            val = getter.method.invoke(obj, new Object[0]);
            for (String toName : getter.toNames) {
                if (getter.shouldOmitNull && val == null) continue;
                if (notFirst) {
                    stream.writeMore();
                } else {
                    notFirst = true;
                }
                stream.writeObjectField(toName);
                if (getter.encoder != null) {
                    getter.encoder.encode(val, stream);
                    continue;
                }
                stream.writeVal(val);
            }
        }
        for (Method unwrapper : this.desc.unWrappers) {
            if (notFirst) {
                stream.writeMore();
            } else {
                notFirst = true;
            }
            unwrapper.invoke(obj, stream);
        }
        stream.writeObjectEnd();
    }
}

