/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jsoniter.any.Any;
import com.networknt.codegen.Generator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import templates.graphql.LICENSE;
import templates.graphql.README;
import templates.graphql.classpath;
import templates.graphql.clientYml;
import templates.graphql.dockerfile;
import templates.graphql.gitignore;
import templates.graphql.logback;
import templates.graphql.middlewareService;
import templates.graphql.pom;
import templates.graphql.primaryCrt;
import templates.graphql.project;
import templates.graphql.routingProvider;
import templates.graphql.schemaClass;
import templates.graphql.schemaClassExample;
import templates.graphql.schemaProvider;
import templates.graphql.secondaryCrt;
import templates.graphql.secretYml;
import templates.graphql.securityYml;
import templates.graphql.serverYml;
import templates.graphql.serviceYml;
import templates.graphql.shutdownHookProvider;
import templates.graphql.startupHookProvider;

public class GraphqlGenerator
implements Generator {
    static ObjectMapper mapper = new ObjectMapper();

    @Override
    public String getFramework() {
        return "light-graphql-4j";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        String schemaPackage = config.get((Object)"schemaPackage").toString();
        String schemaClass2 = config.get((Object)"schemaClass").toString();
        boolean overwriteSchemaClass = config.toBoolean("overwriteSchemaClass");
        boolean enableHttp = config.toBoolean("enableHttp");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportOracle = config.toBoolean("supportOracle");
        boolean supportMysql = config.toBoolean("supportMysql");
        boolean supportPostgresql = config.toBoolean("supportPostgresql");
        boolean supportH2ForTest = config.toBoolean("supportH2ForTest");
        boolean supportClient = config.toBoolean("supportClient");
        this.transfer(targetPath, "", "pom.xml", pom.template(config));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "", "Dockerfile", dockerfile.template(config, expose));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template());
        if (supportOracle) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("oracle.jdbc.pool.OracleDataSource", "jdbc:oracle:thin:@localhost:1521:XE", "SYSTEM", "oracle"));
        }
        if (supportMysql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("com.mysql.jdbc.Driver", "jdbc:mysql://mysqldb:3306/oauth2?useSSL=false", "root", "my-secret-pw"));
        }
        if (supportPostgresql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("org.postgresql.Driver", "jdbc:postgresql://postgresdb:5432/oauth2", "postgres", "my-secret-pw"));
        }
        if (supportH2ForTest) {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("org.h2.jdbcx.JdbcDataSource", "jdbc:h2:~/test", "sa", "sa"));
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, httpPort, enableHttps, httpsPort, enableRegistry));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secretYml.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "security.yml", securityYml.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.main.resources.config.oauth".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config.oauth".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.handler.MiddlewareHandler", middlewareService.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.StartupHookProvider", startupHookProvider.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.ShutdownHookProvider", shutdownHookProvider.template());
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.graphql.router.SchemaProvider", schemaProvider.template(schemaPackage + "." + schemaClass2));
        this.transfer(targetPath, "src.main.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.HandlerProvider", routingProvider.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        if (overwriteSchemaClass) {
            if (model2 == null) {
                this.transfer(targetPath, ("src.main.java." + schemaPackage).replace(".", File.separator), schemaClass2 + ".java", schemaClassExample.template(schemaPackage, schemaClass2));
            } else {
                Files.write(FileSystems.getDefault().getPath(targetPath, "src.main.resources".replace(".", File.separator), "schema.graphqls"), ((String)model2).getBytes(), new OpenOption[0]);
                this.transfer(targetPath, ("src.main.java." + schemaPackage).replace(".", File.separator), schemaClass2 + ".java", schemaClass.template(schemaPackage, schemaClass2));
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator)), new FileAttribute[0]);
        }
        try (InputStream is = GraphqlGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var19_19 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var19_19 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var19_19 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var19_19.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var19_19 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config.tls".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var19_19 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var19_19 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var19_19.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new FileAttribute[0]);
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }
}

