/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.hybrid;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.networknt.codegen.Generator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import templates.hybrid.LICENSE;
import templates.hybrid.classpath;
import templates.hybrid.clientYml;
import templates.hybrid.gitignore;
import templates.hybrid.handler;
import templates.hybrid.handlerTest;
import templates.hybrid.logback;
import templates.hybrid.middlewareService;
import templates.hybrid.primaryCrt;
import templates.hybrid.project;
import templates.hybrid.routingProvider;
import templates.hybrid.secondaryCrt;
import templates.hybrid.secretYml;
import templates.hybrid.securityYml;
import templates.hybrid.serverYml;
import templates.hybrid.service.README;
import templates.hybrid.service.pom;
import templates.hybrid.serviceYml;
import templates.hybrid.shutdownHookProvider;
import templates.hybrid.startupHookProvider;
import templates.hybrid.testServer;

public class HybridServiceGenerator
implements Generator {
    @Override
    public String getFramework() {
        return "light-hybrid-4j-service";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        String rootPackage = config.get((Object)"rootPackage").toString();
        String modelPackage = config.get((Object)"modelPackage").toString();
        String handlerPackage = config.get((Object)"handlerPackage").toString();
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean enableHttp = config.toBoolean("enableHttp");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportOracle = config.toBoolean("supportOracle");
        boolean supportMysql = config.toBoolean("supportMysql");
        boolean supportPostgresql = config.toBoolean("supportPostgresql");
        boolean supportH2ForTest = config.toBoolean("supportH2ForTest");
        boolean supportClient = config.toBoolean("supportClient");
        this.transfer(targetPath, "", "pom.xml", pom.template(config));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template());
        if (supportOracle) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("oracle.jdbc.pool.OracleDataSource", "jdbc:oracle:thin:@localhost:1521:XE", "SYSTEM", "oracle"));
        }
        if (supportMysql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("com.mysql.jdbc.Driver", "jdbc:mysql://mysqldb:3306/oauth2?useSSL=false", "root", "my-secret-pw"));
        }
        if (supportPostgresql) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("org.postgresql.Driver", "jdbc:postgresql://postgresdb:5432/oauth2", "postgres", "my-secret-pw"));
        }
        if (supportH2ForTest) {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "service.yml", serviceYml.template("org.h2.jdbcx.JdbcDataSource", "jdbc:h2:~/test", "sa", "sa"));
        }
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, "49587", enableHttps, httpsPort, enableRegistry));
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "secret.yml", secretYml.template());
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "security.yml", securityYml.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.test.resources.config.oauth".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.test.resources.config.oauth".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.test.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.HandlerProvider", routingProvider.template());
        this.transfer(targetPath, "src.test.resources.META-INF.services".replace(".", File.separator), "com.networknt.handler.MiddlewareHandler", middlewareService.template());
        this.transfer(targetPath, "src.test.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.StartupHookProvider", startupHookProvider.template());
        this.transfer(targetPath, "src.test.resources.META-INF.services".replace(".", File.separator), "com.networknt.server.ShutdownHookProvider", shutdownHookProvider.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        HashMap services = new HashMap();
        Any anyModel = (Any)model2;
        String host = anyModel.toString("host");
        String service2 = anyModel.toString("service");
        List<Any> items = anyModel.get((Object)"action").asList();
        if (items != null && items.size() > 0) {
            for (Any item : items) {
                String example;
                Any any = item.get((Object)"example");
                String string = example = any.valueType() != ValueType.INVALID ? StringEscapeUtils.escapeJson(any.toString()).trim() : "";
                if (overwriteHandler) {
                    this.transfer(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), item.get((Object)"handler") + ".java", handler.template(handlerPackage, host, service2, item, example));
                }
                String serviceId = host + "/" + service2 + "/" + item.get((Object)"name") + "/" + item.get((Object)"version");
                HashMap<String, Any> map = new HashMap<String, Any>();
                map.put("schema", item.get((Object)"schema"));
                map.put("scope", item.get((Object)"scope"));
                services.put(serviceId, map);
            }
            this.transfer(targetPath, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
            if (overwriteHandlerTest) {
                for (Any item : items) {
                    this.transfer(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), item.get((Object)"handler") + "Test.java", handlerTest.template(handlerPackage, host, service2, item));
                }
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator)), new FileAttribute[0]);
        }
        try (InputStream is = HybridServiceGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = HybridServiceGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var25_25 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config.tls".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var25_25 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var25_25 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var25_25.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (Files.notExists(Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator)), new LinkOption[0])) {
            Files.createDirectories(Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator)), new FileAttribute[0]);
        }
        JsonStream.serialize(services, new FileOutputStream(FileSystems.getDefault().getPath(targetPath, "src.main.resources".replace(".", File.separator), "schema.json").toFile()));
    }
}

