/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.execution.TypeInfo;
import graphql.language.Field;
import java.util.List;
import java.util.Map;

public class ExecutionParameters {
    private final TypeInfo typeInfo;
    private final Object source;
    private final Map<String, Object> arguments;
    private final Map<String, List<Field>> fields;

    private ExecutionParameters(TypeInfo typeInfo, Object source, Map<String, List<Field>> fields, Map<String, Object> arguments) {
        this.typeInfo = Assert.assertNotNull(typeInfo, "");
        this.fields = Assert.assertNotNull(fields, "");
        this.source = source;
        this.arguments = arguments;
    }

    public TypeInfo typeInfo() {
        return this.typeInfo;
    }

    public Object source() {
        return this.source;
    }

    public Map<String, List<Field>> fields() {
        return this.fields;
    }

    public Map<String, Object> arguments() {
        return this.arguments;
    }

    public static Builder newParameters() {
        return new Builder();
    }

    public String toString() {
        return String.format("ExecutionParameters { typeInfo=%s, source=%s, fields=%s }", this.typeInfo, this.source, this.fields);
    }

    public static class Builder {
        TypeInfo typeInfo;
        Object source;
        Map<String, List<Field>> fields;
        Map<String, Object> arguments;

        public Builder typeInfo(TypeInfo type) {
            this.typeInfo = type;
            return this;
        }

        public Builder typeInfo(TypeInfo.Builder type) {
            this.typeInfo = type.build();
            return this;
        }

        public Builder fields(Map<String, List<Field>> fields) {
            this.fields = fields;
            return this;
        }

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public ExecutionParameters build() {
            return new ExecutionParameters(this.typeInfo, this.source, this.fields, this.arguments);
        }
    }
}

