/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

public class PropertyDataFetcher<T>
implements DataFetcher<T> {
    private final String propertyName;

    public PropertyDataFetcher(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public T get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return (T)((Map)source).get(this.propertyName);
        }
        return (T)this.getPropertyViaGetter(source, environment.getFieldType());
    }

    private Method findAccessibleMethod(Class root, String methodName) throws NoSuchMethodException {
        for (Class cur = root; cur != null; cur = cur.getSuperclass()) {
            Method m;
            if (!Modifier.isPublic(cur.getModifiers()) || !Modifier.isPublic((m = cur.getMethod(methodName, new Class[0])).getModifiers())) continue;
            return m;
        }
        return root.getMethod(methodName, new Class[0]);
    }

    private Object getPropertyViaGetter(Object object, GraphQLOutputType outputType) {
        try {
            if (this.isBooleanProperty(outputType)) {
                try {
                    return this.getPropertyViaGetterUsingPrefix(object, "is");
                }
                catch (NoSuchMethodException e) {
                    return this.getPropertyViaGetterUsingPrefix(object, "get");
                }
            }
            return this.getPropertyViaGetterUsingPrefix(object, "get");
        }
        catch (NoSuchMethodException e1) {
            return this.getPropertyViaFieldAccess(object);
        }
    }

    private Object getPropertyViaGetterUsingPrefix(Object object, String prefix) throws NoSuchMethodException {
        String getterName = prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        try {
            Method method = this.findAccessibleMethod(object.getClass(), getterName);
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLOutputType outputType) {
        if (outputType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (outputType instanceof GraphQLNonNull) {
            return ((GraphQLNonNull)outputType).getWrappedType() == Scalars.GraphQLBoolean;
        }
        return false;
    }

    private Object getPropertyViaFieldAccess(Object object) {
        try {
            Field field = object.getClass().getField(this.propertyName);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

